/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.process;

import java.io.Serializable;
import java.util.stream.IntStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.types.RowKind;

@Internal
public class RuntimeChangelogMode
implements Serializable {
    private final byte[] changes;
    private final boolean keyOnlyDeletes;

    public RuntimeChangelogMode(byte[] changes, boolean keyOnlyDeletes) {
        this.changes = changes;
        this.keyOnlyDeletes = keyOnlyDeletes;
    }

    public static RuntimeChangelogMode serialize(ChangelogMode mode) {
        RowKind[] kinds = (RowKind[])mode.getContainedKinds().toArray(RowKind[]::new);
        byte[] changes = new byte[kinds.length];
        IntStream.range(0, kinds.length).forEach(i -> {
            changes[i] = kinds[i].toByteValue();
        });
        return new RuntimeChangelogMode(changes, mode.keyOnlyDeletes());
    }

    public ChangelogMode deserialize() {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (byte change : this.changes) {
            builder.addContainedKind(RowKind.fromByteValue((byte)change));
        }
        builder.keyOnlyDeletes(this.keyOnlyDeletes);
        return builder.build();
    }
}

