/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.serialization.SerializerConfigImpl;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractSyncStateTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNBuffer;
import org.apache.flink.table.runtime.operators.rank.utils.AppendOnlyTopNHelper;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public class AppendOnlyTopNFunction
extends AbstractSyncStateTopNFunction {
    private static final long serialVersionUID = -4708453213104128011L;
    private final InternalTypeInfo<RowData> sortKeyType;
    private final TypeSerializer<RowData> inputRowSer;
    private final long cacheSize;
    private transient MapState<RowData, List<RowData>> dataState;
    private transient TopNBuffer buffer;
    private transient SyncStateAppendOnlyTopNHelper helper;

    public AppendOnlyTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator sortKeyGeneratedRecordComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber, long cacheSize) {
        super(ttlConfig, inputRowType, sortKeyGeneratedRecordComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
        this.sortKeyType = sortKeySelector.getProducedType();
        this.inputRowSer = inputRowType.createSerializer((SerializerConfig)new SerializerConfigImpl());
        this.cacheSize = cacheSize;
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ListTypeInfo valueTypeInfo = new ListTypeInfo((TypeInformation)this.inputRowType);
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("data-state-with-append", this.sortKeyType, (TypeInformation)valueTypeInfo);
        if (this.ttlConfig.isEnabled()) {
            mapStateDescriptor.enableTimeToLive(this.ttlConfig);
        }
        this.dataState = this.getRuntimeContext().getMapState(mapStateDescriptor);
        this.helper = new SyncStateAppendOnlyTopNHelper();
        this.helper.registerMetric();
    }

    public void processElement(RowData input, KeyedProcessFunction.Context context, Collector<RowData> out) throws Exception {
        this.initHeapStates();
        this.initRankEnd(input);
        RowData sortKey = (RowData)this.sortKeySelector.getKey((Object)input);
        if (this.checkSortKeyInBufferRange(sortKey, this.buffer)) {
            this.buffer.put(sortKey, (RowData)this.inputRowSer.copy((Object)input));
            Collection<RowData> inputs = this.buffer.get(sortKey);
            this.dataState.put((Object)sortKey, new ArrayList<RowData>(inputs));
            if (this.outputRankNumber || this.hasOffset()) {
                this.helper.processElementWithRowNumber(this.buffer, sortKey, input, this.rankEnd, out);
            } else {
                this.helper.processElementWithoutRowNumber(this.buffer, input, this.rankEnd, out);
            }
        }
    }

    private void initHeapStates() throws Exception {
        this.helper.accRequestCount();
        RowData currentKey = (RowData)this.keyContext.getCurrentKey();
        this.buffer = this.helper.getTopNBufferFromCache(currentKey);
        if (this.buffer == null) {
            this.buffer = new TopNBuffer(this.sortKeyComparator, ArrayList::new);
            this.helper.saveTopNBufferToCache(currentKey, this.buffer);
            Iterator iter = this.dataState.iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    RowData sortKey = (RowData)entry.getKey();
                    List values = (List)entry.getValue();
                    this.buffer.putAll(sortKey, values);
                }
            }
        } else {
            this.helper.accHitCount();
        }
    }

    private class SyncStateAppendOnlyTopNHelper
    extends AppendOnlyTopNHelper {
        public SyncStateAppendOnlyTopNHelper() {
            super(AppendOnlyTopNFunction.this, AppendOnlyTopNFunction.this.cacheSize, AppendOnlyTopNFunction.this.getDefaultTopNSize());
        }

        @Override
        protected void removeFromState(RowData key) throws Exception {
            AppendOnlyTopNFunction.this.dataState.remove((Object)key);
        }

        @Override
        protected void updateState(RowData key, List<RowData> value) throws Exception {
            AppendOnlyTopNFunction.this.dataState.put((Object)key, value);
        }
    }
}

