/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.binary.BinaryRawValueData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;

@Internal
public final class RawValueDataSerializer<T>
extends TypeSerializer<RawValueData<T>> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<T> serializer;

    public RawValueDataSerializer(TypeSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public RawValueData<T> createInstance() {
        return new BinaryRawValueData(this.serializer.createInstance());
    }

    public RawValueData<T> copy(RawValueData<T> from) {
        BinaryRawValueData rawValue = (BinaryRawValueData)from;
        rawValue.ensureMaterialized(this.serializer);
        byte[] bytes = BinarySegmentUtils.copyToBytes((MemorySegment[])rawValue.getSegments(), (int)rawValue.getOffset(), (int)rawValue.getSizeInBytes());
        Object newJavaObject = rawValue.getJavaObject() == null ? null : this.serializer.copy(rawValue.getJavaObject());
        return new BinaryRawValueData(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length, newJavaObject);
    }

    public RawValueData<T> copy(RawValueData<T> from, RawValueData<T> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(RawValueData<T> record, DataOutputView target) throws IOException {
        BinaryRawValueData rawValue = (BinaryRawValueData)record;
        rawValue.ensureMaterialized(this.serializer);
        target.writeInt(rawValue.getSizeInBytes());
        BinarySegmentUtils.copyToView((MemorySegment[])rawValue.getSegments(), (int)rawValue.getOffset(), (int)rawValue.getSizeInBytes(), (DataOutputView)target);
    }

    public RawValueData<T> deserialize(DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        return new BinaryRawValueData(new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes)}, 0, bytes.length);
    }

    public RawValueData<T> deserialize(RawValueData<T> record, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public RawValueDataSerializer<T> duplicate() {
        return new RawValueDataSerializer<T>(this.serializer.duplicate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RawValueDataSerializer that = (RawValueDataSerializer)((Object)o);
        return this.serializer.equals(that.serializer);
    }

    public int hashCode() {
        return this.serializer.hashCode();
    }

    public TypeSerializerSnapshot<RawValueData<T>> snapshotConfiguration() {
        return new RawValueDataSerializerSnapshot(this);
    }

    public TypeSerializer<T> getInnerSerializer() {
        return this.serializer;
    }

    public static final class RawValueDataSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<RawValueData<T>, RawValueDataSerializer<T>> {
        public RawValueDataSerializerSnapshot() {
        }

        public RawValueDataSerializerSnapshot(RawValueDataSerializer<T> serializerInstance) {
            super(serializerInstance);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 0;
        }

        protected TypeSerializer<?>[] getNestedSerializers(RawValueDataSerializer<T> outerSerializer) {
            return new TypeSerializer[]{outerSerializer.serializer};
        }

        protected RawValueDataSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new RawValueDataSerializer(nestedSerializers[0]);
        }
    }
}

