/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv;

import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TSFBuilder;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.csv.CsvParser;

public class CsvFactoryBuilder
extends TSFBuilder<CsvFactory, CsvFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    protected CsvFactoryBuilder() {
        this._formatParserFeatures = CsvFactory.DEFAULT_CSV_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = CsvFactory.DEFAULT_CSV_GENERATOR_FEATURE_FLAGS;
    }

    public CsvFactoryBuilder(CsvFactory base) {
        super(base);
        this._formatParserFeatures = base._csvParserFeatures;
        this._formatGeneratorFeatures = base._csvGeneratorFeatures;
    }

    public CsvFactoryBuilder enable(CsvParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder enable(CsvParser.Feature first, CsvParser.Feature ... other) {
        this._formatParserFeatures |= first.getMask();
        for (CsvParser.Feature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder disable(CsvParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder disable(CsvParser.Feature first, CsvParser.Feature ... other) {
        this._formatParserFeatures &= ~first.getMask();
        for (CsvParser.Feature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder configure(CsvParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvFactoryBuilder enable(CsvGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder enable(CsvGenerator.Feature first, CsvGenerator.Feature ... other) {
        this._formatGeneratorFeatures |= first.getMask();
        for (CsvGenerator.Feature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder disable(CsvGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder disable(CsvGenerator.Feature first, CsvGenerator.Feature ... other) {
        this._formatGeneratorFeatures &= ~first.getMask();
        for (CsvGenerator.Feature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (CsvFactoryBuilder)this._this();
    }

    public CsvFactoryBuilder configure(CsvGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    @Override
    public CsvFactory build() {
        return new CsvFactory(this);
    }
}

