/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collection;
import java.util.Collections;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.TopicPartition;

public class PausePartitionsEvent
extends CompletableApplicationEvent<Void> {
    private final Collection<TopicPartition> partitions;

    public PausePartitionsEvent(Collection<TopicPartition> partitions, long deadlineMs) {
        super(ApplicationEvent.Type.PAUSE_PARTITIONS, deadlineMs);
        this.partitions = Collections.unmodifiableCollection(partitions);
    }

    public Collection<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    public String toStringBase() {
        return super.toStringBase() + ", partitions=" + String.valueOf(this.partitions);
    }
}

