/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.allround;

import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.iteration.IterationListener;
import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.AbstractWrapperOperator;
import org.apache.flink.iteration.operator.OperatorStateUtils;
import org.apache.flink.iteration.operator.OperatorUtils;
import org.apache.flink.iteration.operator.allround.EpochAware;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorEventDispatcher;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactoryUtil;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.StreamOperatorStateContext;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

public abstract class AbstractAllRoundWrapperOperator<T, S extends StreamOperator<T>>
extends AbstractWrapperOperator<T> {
    protected final S wrappedOperator;
    private int latestEpochWatermark = -1;
    private ListState<Integer> parallelismState;
    private ListState<Integer> latestEpochWatermarkState;

    public AbstractAllRoundWrapperOperator(StreamOperatorParameters<IterationRecord<T>> parameters, StreamOperatorFactory<T> operatorFactory) {
        super(parameters, operatorFactory);
        this.wrappedOperator = (StreamOperator)StreamOperatorFactoryUtil.createOperator(operatorFactory, (StreamTask)parameters.getContainingTask(), (StreamConfig)OperatorUtils.createWrappedOperatorConfig((StreamConfig)parameters.getStreamConfig(), (ClassLoader)this.containingTask.getUserCodeClassLoader()), (Output)this.proxyOutput, (OperatorEventDispatcher)parameters.getOperatorEventDispatcher()).f0;
        OperatorUtils.processOperatorOrUdfIfSatisfy(this.wrappedOperator, EpochAware.class, epochWatermarkAware -> epochWatermarkAware.setEpochSupplier(this.epochWatermarkSupplier));
    }

    @Override
    public void onEpochWatermarkIncrement(int epochWatermark) throws IOException {
        if (epochWatermark > this.latestEpochWatermark) {
            this.latestEpochWatermark = epochWatermark;
            this.setIterationContextRound(epochWatermark);
            OperatorUtils.processOperatorOrUdfIfSatisfy(this.wrappedOperator, IterationListener.class, listener -> this.notifyEpochWatermarkIncrement((IterationListener<?>)listener, epochWatermark));
            this.clearIterationContextRound();
        }
        super.onEpochWatermarkIncrement(epochWatermark);
    }

    public void initializeState(StreamTaskStateInitializer streamTaskStateManager) throws Exception {
        RecordingStreamTaskStateInitializer recordingStreamTaskStateInitializer = new RecordingStreamTaskStateInitializer(streamTaskStateManager);
        this.wrappedOperator.initializeState((StreamTaskStateInitializer)recordingStreamTaskStateInitializer);
        Preconditions.checkState((recordingStreamTaskStateInitializer.lastCreated != null ? 1 : 0) != 0);
        OperatorStateBackend operatorStateStore = recordingStreamTaskStateInitializer.lastCreated.operatorStateBackend();
        this.parallelismState = operatorStateStore.getUnionListState(new ListStateDescriptor("parallelism", (TypeSerializer)IntSerializer.INSTANCE));
        OperatorStateUtils.getUniqueElement(this.parallelismState, "parallelism").ifPresent(oldParallelism -> Preconditions.checkState((oldParallelism.intValue() == this.containingTask.getEnvironment().getTaskInfo().getNumberOfParallelSubtasks() ? 1 : 0) != 0, (Object)("The all-round wrapper operator is recovered with parallelism changed from " + oldParallelism + " to " + this.containingTask.getEnvironment().getTaskInfo().getNumberOfParallelSubtasks())));
        this.latestEpochWatermarkState = operatorStateStore.getListState(new ListStateDescriptor("latestEpoch", (TypeSerializer)IntSerializer.INSTANCE));
        OperatorStateUtils.getUniqueElement(this.latestEpochWatermarkState, "latestEpoch").ifPresent(oldLatestEpochWatermark -> {
            this.latestEpochWatermark = oldLatestEpochWatermark;
        });
    }

    public OperatorSnapshotFutures snapshotState(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, CheckpointStreamFactory storageLocation) throws Exception {
        this.parallelismState.clear();
        if (this.containingTask.getEnvironment().getTaskInfo().getIndexOfThisSubtask() == 0) {
            this.parallelismState.update(Collections.singletonList(this.containingTask.getEnvironment().getTaskInfo().getNumberOfParallelSubtasks()));
        }
        this.latestEpochWatermarkState.update(Collections.singletonList(this.latestEpochWatermark));
        return this.wrappedOperator.snapshotState(checkpointId, timestamp, checkpointOptions, storageLocation);
    }

    public void open() throws Exception {
        this.wrappedOperator.open();
    }

    public void finish() throws Exception {
        this.wrappedOperator.finish();
    }

    public void close() throws Exception {
        this.wrappedOperator.close();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.wrappedOperator.prepareSnapshotPreBarrier(checkpointId);
    }

    public void setKeyContextElement1(StreamRecord<?> record) throws Exception {
        this.wrappedOperator.setKeyContextElement1(record);
    }

    public void setKeyContextElement2(StreamRecord<?> record) throws Exception {
        this.wrappedOperator.setKeyContextElement2(record);
    }

    public OperatorMetricGroup getMetricGroup() {
        return this.wrappedOperator.getMetricGroup();
    }

    public OperatorID getOperatorID() {
        return this.wrappedOperator.getOperatorID();
    }

    public void notifyCheckpointComplete(long checkpointId) throws Exception {
        this.wrappedOperator.notifyCheckpointComplete(checkpointId);
    }

    public void notifyCheckpointAborted(long checkpointId) throws Exception {
        this.wrappedOperator.notifyCheckpointAborted(checkpointId);
    }

    public void setCurrentKey(Object key) {
        this.wrappedOperator.setCurrentKey(key);
    }

    public Object getCurrentKey() {
        return this.wrappedOperator.getCurrentKey();
    }

    @VisibleForTesting
    int getLatestEpochWatermark() {
        return this.latestEpochWatermark;
    }

    private static class RecordingStreamTaskStateInitializer
    implements StreamTaskStateInitializer {
        private final StreamTaskStateInitializer wrapped;
        StreamOperatorStateContext lastCreated;

        public RecordingStreamTaskStateInitializer(StreamTaskStateInitializer wrapped) {
            this.wrapped = wrapped;
        }

        public StreamOperatorStateContext streamOperatorStateContext(@Nonnull OperatorID operatorID, @Nonnull String s, @Nonnull ProcessingTimeService processingTimeService, @Nonnull KeyContext keyContext, @Nullable TypeSerializer<?> typeSerializer, @Nonnull CloseableRegistry closeableRegistry, @Nonnull MetricGroup metricGroup, double v, boolean b) throws Exception {
            this.lastCreated = this.wrapped.streamOperatorStateContext(operatorID, s, processingTimeService, keyContext, typeSerializer, closeableRegistry, metricGroup, v, b);
            return this.lastCreated;
        }
    }
}

