/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.progresstrack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.iteration.progresstrack.OperatorEpochWatermarkTrackerListener;
import org.apache.flink.util.Preconditions;

public class OperatorEpochWatermarkTracker {
    private final OperatorEpochWatermarkTrackerListener progressTrackerListener;
    private final List<InputStatus> inputStatuses;
    private final LowerBoundMaintainer allInputsLowerBound;

    OperatorEpochWatermarkTracker(int[] numberOfChannels, OperatorEpochWatermarkTrackerListener progressTrackerListener) {
        Preconditions.checkState((numberOfChannels != null && numberOfChannels.length >= 1 ? 1 : 0) != 0);
        this.progressTrackerListener = (OperatorEpochWatermarkTrackerListener)Preconditions.checkNotNull((Object)progressTrackerListener);
        this.inputStatuses = new ArrayList<InputStatus>(numberOfChannels.length);
        for (int numberOfChannel : numberOfChannels) {
            this.inputStatuses.add(new InputStatus(numberOfChannel));
        }
        this.allInputsLowerBound = new LowerBoundMaintainer(numberOfChannels.length);
    }

    public void onEpochWatermark(int inputIndex, String sender, int epochWatermark) throws IOException {
        InputStatus inputStatus = this.inputStatuses.get(inputIndex);
        inputStatus.onUpdate(sender, epochWatermark);
        this.tryUpdateLowerBound(inputIndex);
    }

    public void finish(int inputIndex) throws IOException {
        this.inputStatuses.get(inputIndex).finish();
        this.tryUpdateLowerBound(inputIndex);
    }

    private void tryUpdateLowerBound(int changedInputIndex) throws IOException {
        if (this.inputStatuses.get(changedInputIndex).getInputLowerBound() > this.allInputsLowerBound.getValue(changedInputIndex)) {
            int oldLowerBound = this.allInputsLowerBound.getLowerBound();
            this.allInputsLowerBound.updateValue(changedInputIndex, this.inputStatuses.get(changedInputIndex).getInputLowerBound());
            if (this.allInputsLowerBound.getLowerBound() > oldLowerBound) {
                this.progressTrackerListener.onEpochWatermarkIncrement(this.allInputsLowerBound.getLowerBound());
            }
        }
    }

    @VisibleForTesting
    int[] getNumberOfInputs() {
        return this.inputStatuses.stream().mapToInt(inputStatus -> ((InputStatus)inputStatus).numberOfChannels).toArray();
    }

    private static class LowerBoundMaintainer {
        private final int[] values;
        private int lowerBound;

        public LowerBoundMaintainer(int numberOfValues) {
            this.values = new int[numberOfValues];
            Arrays.fill(this.values, Integer.MIN_VALUE);
            this.lowerBound = Integer.MIN_VALUE;
        }

        public int getLowerBound() {
            return this.lowerBound;
        }

        public int getValue(int channel) {
            return this.values[channel];
        }

        public void updateValue(int channel, int value) {
            Preconditions.checkState((value >= this.values[channel] ? 1 : 0) != 0, (Object)String.format("The channel %d received an outdated value %d, which currently is %d", channel, value, this.values[channel]));
            if (value > this.values[channel]) {
                long oldValue = this.values[channel];
                this.values[channel] = value;
                if (oldValue == (long)this.lowerBound) {
                    this.lowerBound = this.calculateLowerBound();
                }
            }
        }

        private int calculateLowerBound() {
            int newLowerBound = this.values[0];
            for (int i = 1; i < this.values.length; ++i) {
                if (this.values[i] >= newLowerBound) continue;
                newLowerBound = this.values[i];
            }
            return newLowerBound;
        }
    }

    private static class InputStatus {
        private final int numberOfChannels;
        private final Map<String, Integer> senderIndices;
        private final LowerBoundMaintainer allChannelsLowerBound;

        public InputStatus(int numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            this.senderIndices = new HashMap<String, Integer>(numberOfChannels);
            this.allChannelsLowerBound = new LowerBoundMaintainer(numberOfChannels);
        }

        public void onUpdate(String sender, int epochWatermark) {
            int index = this.senderIndices.computeIfAbsent(sender, k -> this.senderIndices.size());
            Preconditions.checkState((index < this.numberOfChannels ? 1 : 0) != 0);
            this.allChannelsLowerBound.updateValue(index, epochWatermark);
        }

        public void finish() {
            for (int i = 0; i < this.numberOfChannels; ++i) {
                this.allChannelsLowerBound.updateValue(i, Integer.MAX_VALUE);
            }
        }

        public int getInputLowerBound() {
            return this.allChannelsLowerBound.getLowerBound();
        }
    }
}

