/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.ngram;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.feature.ngram.NGramParams;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.util.Preconditions;

public class NGram
implements Transformer<NGram>,
NGramParams<NGram> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public NGram() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        Expression nGramUdf = (Expression)Expressions.call(NGramUdf.class, (Object[])new Object[]{Expressions.$((String)this.getInputCol()), this.getN()}).as(this.getOutputCol(), new String[0]);
        Table output = inputs[0].addColumns(new Expression[]{nGramUdf});
        return new Table[]{output};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    public static NGram load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (NGram)ReadWriteUtils.loadStageParam(path);
    }

    public static class NGramUdf
    extends ScalarFunction {
        public String[] eval(String[] items, int n) {
            int numItems = items.length;
            if (n > numItems) {
                return new String[0];
            }
            String[] output = new String[numItems - n + 1];
            for (int i = 0; i < numItems - n + 1; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < n; ++j) {
                    stringBuilder.append(items[i + j]);
                    stringBuilder.append(" ");
                }
                output[i] = stringBuilder.deleteCharAt(stringBuilder.length() - 1).toString();
            }
            return output;
        }
    }
}

