/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.onehotencoder;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;

public class OneHotEncoderModelData {
    public static DataStream<Tuple2<Integer, Integer>> getModelDataStream(Table modelData) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelData).getTableEnvironment();
        return tEnv.toDataStream(modelData).map((MapFunction)new MapFunction<Row, Tuple2<Integer, Integer>>(){

            public Tuple2<Integer, Integer> map(Row row) {
                return new Tuple2((Object)((Integer)row.getField("f0")), (Object)((Integer)row.getField("f1")));
            }
        });
    }

    public static class ModelDataStreamFormat
    extends SimpleStreamFormat<Tuple2<Integer, Integer>> {
        public StreamFormat.Reader<Tuple2<Integer, Integer>> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<Tuple2<Integer, Integer>>(){
                private final Input input;
                {
                    this.input = new Input((InputStream)stream);
                }

                public Tuple2<Integer, Integer> read() {
                    if (this.input.eof()) {
                        return null;
                    }
                    int f0 = this.input.readInt();
                    int f1 = this.input.readInt();
                    return new Tuple2((Object)f0, (Object)f1);
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<Tuple2<Integer, Integer>> getProducedType() {
            return Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.INT, Types.INT});
        }
    }

    public static class ModelDataEncoder
    implements Encoder<Tuple2<Integer, Integer>> {
        public void encode(Tuple2<Integer, Integer> modelData, OutputStream outputStream) {
            Output output = new Output(outputStream);
            output.writeInt(((Integer)modelData.f0).intValue());
            output.writeInt(((Integer)modelData.f1).intValue());
            output.flush();
        }
    }
}

