/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.param;

import java.io.IOException;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidator;
import org.apache.flink.ml.param.ParamValidators;

public class FloatParam
extends Param<Float> {
    public FloatParam(String name, String description, Float defaultValue, ParamValidator<Float> validator) {
        super(name, Float.class, description, defaultValue, validator);
    }

    public FloatParam(String name, String description, Float defaultValue) {
        this(name, description, defaultValue, ParamValidators.alwaysTrue());
    }

    @Override
    public Float jsonDecode(Object json) throws IOException {
        if (json instanceof Double) {
            return Float.valueOf(((Double)json).floatValue());
        }
        if (json instanceof String) {
            return Float.valueOf((String)json);
        }
        return (Float)json;
    }
}

