/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.countvectorizer.CountVectorizer;
import org.apache.flink.ml.feature.countvectorizer.CountVectorizerModel;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class CountVectorizerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource dataStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{new String[]{"a", "c", "b", "c"}}), Row.of((Object[])new Object[]{new String[]{"c", "d", "e"}}), Row.of((Object[])new Object[]{new String[]{"a", "b", "c"}}), Row.of((Object[])new Object[]{new String[]{"e", "f"}}), Row.of((Object[])new Object[]{new String[]{"a", "c", "a"}})});
        Table inputTable = tEnv.fromDataStream((DataStream)dataStream).as("input", new String[0]);
        CountVectorizer countVectorizer = new CountVectorizer();
        CountVectorizerModel model = countVectorizer.fit(new Table[]{inputTable});
        Table outputTable = model.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValue = (String[])row.getField(countVectorizer.getInputCol());
            SparseVector outputValue = (SparseVector)row.getField(countVectorizer.getOutputCol());
            System.out.printf("Input Value: %-15s \tOutput Value: %s\n", Arrays.toString(inputValue), outputValue.toString());
        }
    }
}

