/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.execution.librarycache.FlinkUserCodeClassLoaders;
import org.apache.flink.statefun.flink.core.FlinkConfigExtractor;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfigValidator;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverseValidator;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverses;
import org.apache.flink.statefun.flink.core.feedback.FeedbackKey;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.translation.FlinkUniverse;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.util.FlinkUserCodeClassLoader;

public class StatefulFunctionsJob {
    private static final AtomicInteger FEEDBACK_INVOCATION_ID_SEQ = new AtomicInteger();

    public static void main(String ... args) throws Exception {
        ParameterTool parameterTool = ParameterTool.fromArgs((String[])args);
        Map globalConfigurations = parameterTool.toMap();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        Configuration flinkConfig = FlinkConfigExtractor.reflectivelyExtractFromEnv(env);
        StatefulFunctionsConfigValidator.validate(flinkConfig);
        StatefulFunctionsConfig stateFunConfig = StatefulFunctionsConfig.fromFlinkConfiguration(flinkConfig);
        stateFunConfig.addAllGlobalConfigurations(globalConfigurations);
        stateFunConfig.setProvider(new StatefulFunctionsUniverses.ClassPathUniverseProvider());
        StatefulFunctionsJob.main(env, stateFunConfig);
    }

    public static void main(StreamExecutionEnvironment env, StatefulFunctionsConfig stateFunConfig) throws Exception {
        Objects.requireNonNull(env);
        Objects.requireNonNull(stateFunConfig);
        StatefulFunctionsJob.setDefaultContextClassLoaderIfAbsent();
        env.getConfig().enableObjectReuse();
        StatefulFunctionsUniverse statefulFunctionsUniverse = StatefulFunctionsUniverses.get(Thread.currentThread().getContextClassLoader(), stateFunConfig);
        StatefulFunctionsUniverseValidator statefulFunctionsUniverseValidator = new StatefulFunctionsUniverseValidator();
        statefulFunctionsUniverseValidator.validate(statefulFunctionsUniverse);
        FeedbackKey<Message> feedbackKey = new FeedbackKey<Message>("statefun-pipeline", FEEDBACK_INVOCATION_ID_SEQ.incrementAndGet());
        FlinkUniverse flinkUniverse = new FlinkUniverse(feedbackKey, stateFunConfig, statefulFunctionsUniverse);
        flinkUniverse.configure(env);
        env.execute(stateFunConfig.getFlinkJobName());
    }

    private static void setDefaultContextClassLoaderIfAbsent() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            URLClassLoader flinkClassLoader = FlinkUserCodeClassLoaders.parentFirst((URL[])new URL[0], (ClassLoader)StatefulFunctionsJob.class.getClassLoader(), (Consumer)FlinkUserCodeClassLoader.NOOP_EXCEPTION_HANDLER, (boolean)false);
            Thread.currentThread().setContextClassLoader(flinkClassLoader);
        }
    }
}

