/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.ArrayDeque;
import java.util.Objects;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.ApplyingContext;
import org.apache.flink.statefun.flink.core.functions.FunctionRepository;
import org.apache.flink.statefun.flink.core.functions.LiveFunction;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.sdk.FunctionType;

final class LocalFunctionGroup {
    private final FunctionRepository repository;
    private final ApplyingContext context;
    private final ArrayDeque<Object> pending = new ArrayDeque(4096);

    @Inject
    LocalFunctionGroup(@Label(value="function-repository") FunctionRepository repository, @Label(value="applying-context") ApplyingContext context) {
        this.repository = Objects.requireNonNull(repository);
        this.context = Objects.requireNonNull(context);
    }

    void enqueue(Message message) {
        FunctionType targetType = message.target().type();
        LiveFunction fn = this.repository.get(targetType);
        this.pending.addLast(fn);
        this.pending.addLast(message);
    }

    boolean processNextEnvelope() {
        Object fn = this.pending.pollFirst();
        if (fn == null) {
            return false;
        }
        LiveFunction liveFunction = (LiveFunction)fn;
        Message message = (Message)this.pending.pollFirst();
        this.context.apply(liveFunction, message);
        return true;
    }
}

