/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.flink.statefun.flink.core.common.PolyglotUtil;
import org.apache.flink.statefun.flink.core.httpfn.RetryingCallback;
import org.apache.flink.statefun.flink.core.metrics.RemoteInvocationMetrics;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.ToFunctionRequestSummary;
import org.apache.flink.statefun.sdk.reqreply.generated.FromFunction;
import org.apache.flink.statefun.sdk.reqreply.generated.ToFunction;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

final class DefaultHttpRequestReplyClient
implements RequestReplyClient {
    private static final MediaType MEDIA_TYPE_BINARY = MediaType.parse((String)"application/octet-stream");
    private final HttpUrl url;
    private final OkHttpClient client;
    private final BooleanSupplier isShutdown;

    DefaultHttpRequestReplyClient(HttpUrl url, OkHttpClient client, BooleanSupplier isShutdown) {
        this.url = Objects.requireNonNull(url);
        this.client = Objects.requireNonNull(client);
        this.isShutdown = Objects.requireNonNull(isShutdown);
    }

    @Override
    public CompletableFuture<FromFunction> call(ToFunctionRequestSummary requestSummary, RemoteInvocationMetrics metrics, ToFunction toFunction) {
        Request request = new Request.Builder().url(this.url).post(RequestBody.create((MediaType)MEDIA_TYPE_BINARY, (byte[])toFunction.toByteArray())).build();
        Call newCall = this.client.newCall(request);
        RetryingCallback callback = new RetryingCallback(requestSummary, metrics, newCall.timeout(), this.isShutdown);
        callback.attachToCall(newCall);
        return callback.future().thenApply(DefaultHttpRequestReplyClient::parseResponse);
    }

    private static FromFunction parseResponse(Response response) {
        InputStream httpResponseBody = DefaultHttpRequestReplyClient.responseBody(response);
        try {
            FromFunction fromFunction = PolyglotUtil.parseProtobufOrThrow(FromFunction.parser(), httpResponseBody);
            return fromFunction;
        }
        finally {
            IOUtils.closeQuietly((AutoCloseable)httpResponseBody);
        }
    }

    private static InputStream responseBody(Response httpResponse) {
        Preconditions.checkState((boolean)httpResponse.isSuccessful(), (String)"Unexpected HTTP status code %s", (Object[])new Object[]{httpResponse.code()});
        Preconditions.checkState((httpResponse.body() != null ? 1 : 0) != 0, (Object)"Unexpected empty HTTP response (no body)");
        Preconditions.checkState((boolean)Objects.equals(httpResponse.body().contentType(), MEDIA_TYPE_BINARY), (String)"Wrong HTTP content-type %s", (Object[])new Object[]{httpResponse.body().contentType()});
        return httpResponse.body().byteStream();
    }
}

