/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.io.Closeable;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.flink.shaded.netty4.io.netty.bootstrap.Bootstrap;
import org.apache.flink.shaded.netty4.io.netty.channel.Channel;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelOption;
import org.apache.flink.shaded.netty4.io.netty.channel.EventLoop;
import org.apache.flink.shaded.netty4.io.netty.channel.pool.ChannelHealthChecker;
import org.apache.flink.shaded.netty4.io.netty.channel.pool.ChannelPoolHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.pool.FixedChannelPool;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import org.apache.flink.shaded.netty4.io.netty.handler.ssl.SslContext;
import org.apache.flink.shaded.netty4.io.netty.util.concurrent.ScheduledFuture;
import org.apache.flink.statefun.flink.core.metrics.RemoteInvocationMetrics;
import org.apache.flink.statefun.flink.core.nettyclient.ChannelAttributes;
import org.apache.flink.statefun.flink.core.nettyclient.Endpoint;
import org.apache.flink.statefun.flink.core.nettyclient.HttpConnectionPoolManager;
import org.apache.flink.statefun.flink.core.nettyclient.NettyClientService;
import org.apache.flink.statefun.flink.core.nettyclient.NettyHeaders;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequest;
import org.apache.flink.statefun.flink.core.nettyclient.NettyRequestReplySpec;
import org.apache.flink.statefun.flink.core.nettyclient.NettySharedResources;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.ToFunctionRequestSummary;
import org.apache.flink.statefun.sdk.reqreply.generated.FromFunction;
import org.apache.flink.statefun.sdk.reqreply.generated.ToFunction;

final class NettyClient
implements RequestReplyClient,
NettyClientService {
    private final NettySharedResources shared;
    private final FixedChannelPool pool;
    private final Endpoint endpoint;
    private final ReadOnlyHttpHeaders headers;
    private final long totalRequestBudgetInNanos;
    private final EventLoop eventLoop;

    public static NettyClient from(NettySharedResources shared, NettyRequestReplySpec spec, URI endpointUrl) {
        Endpoint endpoint = new Endpoint(endpointUrl);
        long totalRequestBudgetInNanos = spec.callTimeout.toNanos();
        ReadOnlyHttpHeaders headers = NettyHeaders.defaultHeadersFor(endpoint.serviceAddress());
        Bootstrap bootstrap = shared.bootstrap().clone();
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)spec.connectTimeout.toMillis()));
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.remoteAddress((SocketAddress)endpoint.serviceAddress());
        SslContext sslContext = endpoint.useTls() ? shared.sslContext() : null;
        HttpConnectionPoolManager poolHandler = new HttpConnectionPoolManager(sslContext, spec, endpoint.serviceAddress().getHostString(), endpoint.serviceAddress().getPort());
        FixedChannelPool pool = new FixedChannelPool(bootstrap, (ChannelPoolHandler)poolHandler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, spec.connectTimeout.toMillis(), spec.connectionPoolMaxSize, Integer.MAX_VALUE, true, true);
        shared.registerClosable(() -> ((FixedChannelPool)pool).closeAsync());
        EventLoop eventLoop = bootstrap.config().group().next();
        return new NettyClient(shared, eventLoop, pool, endpoint, headers, totalRequestBudgetInNanos);
    }

    private NettyClient(NettySharedResources shared, EventLoop anEventLoop, FixedChannelPool pool, Endpoint endpoint, ReadOnlyHttpHeaders defaultHttpHeaders, long totalRequestBudgetInNanos) {
        this.shared = Objects.requireNonNull(shared);
        this.eventLoop = Objects.requireNonNull(anEventLoop);
        this.pool = Objects.requireNonNull(pool);
        this.endpoint = Objects.requireNonNull(endpoint);
        this.headers = Objects.requireNonNull(defaultHttpHeaders);
        this.totalRequestBudgetInNanos = totalRequestBudgetInNanos;
    }

    @Override
    public CompletableFuture<FromFunction> call(ToFunctionRequestSummary requestSummary, RemoteInvocationMetrics metrics, ToFunction toFunction) {
        NettyRequest request = new NettyRequest(this, metrics, requestSummary, toFunction);
        return request.start();
    }

    @Override
    public void acquireChannel(BiConsumer<Channel, Throwable> consumer) {
        this.pool.acquire().addListener(future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                consumer.accept(null, cause);
            } else {
                Channel ch = (Channel)future.getNow();
                consumer.accept(ch, null);
            }
        });
    }

    @Override
    public void releaseChannel(Channel channel) {
        EventLoop chEventLoop = channel.eventLoop();
        if (chEventLoop.inEventLoop()) {
            this.releaseChannel0(channel);
        } else {
            chEventLoop.execute(() -> this.releaseChannel0(channel));
        }
    }

    @Override
    public String queryPath() {
        return this.endpoint.queryPath();
    }

    @Override
    public ReadOnlyHttpHeaders headers() {
        return this.headers;
    }

    @Override
    public long totalRequestBudgetInNanos() {
        return this.totalRequestBudgetInNanos;
    }

    @Override
    public Closeable newTimeout(Runnable client, long delayInNanos) {
        ScheduledFuture future = this.eventLoop.schedule(client, delayInNanos, TimeUnit.NANOSECONDS);
        return () -> future.cancel(false);
    }

    @Override
    public void runOnEventLoop(Runnable task) {
        Objects.requireNonNull(task);
        if (this.eventLoop.inEventLoop()) {
            task.run();
        } else {
            this.eventLoop.execute(task);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shared.isShutdown();
    }

    @Override
    public long systemNanoTime() {
        return System.nanoTime();
    }

    @Override
    public <T> void writeAndFlush(T what, Channel where, BiConsumer<Void, Throwable> andThen) {
        where.writeAndFlush(what).addListener(future -> {
            Throwable cause = future.cause();
            andThen.accept(null, cause);
        });
    }

    private void releaseChannel0(Channel channel) {
        if (!channel.isActive()) {
            this.pool.release(channel);
            return;
        }
        if (channel.attr(ChannelAttributes.EXPIRED).get() != Boolean.TRUE) {
            this.pool.release(channel);
            return;
        }
        channel.close().addListener(ignored -> this.pool.release(channel));
    }
}

