/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.datacache.nonkeyed;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.util.Preconditions;

@Internal
public class Segment {
    private final Path path;
    private final int count;
    private long fsSize = 0L;
    private List<MemorySegment> cache = new ArrayList<MemorySegment>();

    Segment(Path path, int count, long fsSize) {
        this.path = path;
        this.count = count;
        this.fsSize = fsSize;
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((fsSize > 0L ? 1 : 0) != 0);
    }

    Segment(Path path, int count, List<MemorySegment> cache) {
        this.path = path;
        this.count = count;
        this.cache = cache;
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0);
    }

    void setCache(List<MemorySegment> cache) {
        this.cache = cache;
    }

    void setFsSize(long fsSize) {
        Preconditions.checkArgument((fsSize > 0L ? 1 : 0) != 0);
        this.fsSize = fsSize;
    }

    Path getPath() {
        return this.path;
    }

    int getCount() {
        return this.count;
    }

    long getFsSize() {
        return this.fsSize;
    }

    List<MemorySegment> getCache() {
        return this.cache;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Segment)) {
            return false;
        }
        Segment segment = (Segment)o;
        return this.count == segment.count && Objects.equals(this.path, segment.path);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.count);
    }

    public String toString() {
        return "Segment{path=" + this.path + ", count=" + this.count + '}';
    }
}

