/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator.allround;

import org.apache.flink.iteration.IterationRecord;
import org.apache.flink.iteration.operator.allround.AbstractAllRoundWrapperOperator;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.function.ThrowingConsumer;

public class TwoInputAllRoundWrapperOperator<IN1, IN2, OUT>
extends AbstractAllRoundWrapperOperator<OUT, TwoInputStreamOperator<IN1, IN2, OUT>>
implements TwoInputStreamOperator<IterationRecord<IN1>, IterationRecord<IN2>, IterationRecord<OUT>>,
BoundedMultiInput {
    private final StreamRecord<IN1> reusedInput1 = new StreamRecord(null, 0L);
    private final StreamRecord<IN2> reusedInput2 = new StreamRecord(null, 0L);

    public TwoInputAllRoundWrapperOperator(StreamOperatorParameters<IterationRecord<OUT>> parameters, StreamOperatorFactory<OUT> operatorFactory) {
        super(parameters, operatorFactory);
    }

    public void processElement1(StreamRecord<IterationRecord<IN1>> element) throws Exception {
        this.processElement(element, 0, this.reusedInput1, arg_0 -> ((TwoInputStreamOperator)((TwoInputStreamOperator)this.wrappedOperator)).processElement1(arg_0));
    }

    public void processElement2(StreamRecord<IterationRecord<IN2>> element) throws Exception {
        this.processElement(element, 1, this.reusedInput2, arg_0 -> ((TwoInputStreamOperator)((TwoInputStreamOperator)this.wrappedOperator)).processElement2(arg_0));
    }

    private <IN> void processElement(StreamRecord<IterationRecord<IN>> element, int inputIndex, StreamRecord<IN> reusedInput, ThrowingConsumer<StreamRecord<IN>, Exception> processor) throws Exception {
        switch (((IterationRecord)element.getValue()).getType()) {
            case RECORD: {
                reusedInput.replace(((IterationRecord)element.getValue()).getValue(), element.getTimestamp());
                this.setIterationContextRound(((IterationRecord)element.getValue()).getEpoch());
                processor.accept(reusedInput);
                this.clearIterationContextRound();
                break;
            }
            case EPOCH_WATERMARK: {
                this.onEpochWatermarkEvent(inputIndex, (IterationRecord)element.getValue());
                break;
            }
            default: {
                throw new FlinkRuntimeException("Not supported iteration record type: " + element);
            }
        }
    }

    public void processWatermark1(Watermark mark) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processWatermark1(mark);
    }

    public void processWatermark2(Watermark mark) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processWatermark2(mark);
    }

    public void processLatencyMarker1(LatencyMarker latencyMarker) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processLatencyMarker1(latencyMarker);
    }

    public void processLatencyMarker2(LatencyMarker latencyMarker) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processLatencyMarker2(latencyMarker);
    }

    public void processWatermarkStatus1(WatermarkStatus watermarkStatus) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processWatermarkStatus1(watermarkStatus);
    }

    public void processWatermarkStatus2(WatermarkStatus watermarkStatus) throws Exception {
        ((TwoInputStreamOperator)this.wrappedOperator).processWatermarkStatus2(watermarkStatus);
    }

    @Override
    public void endInput(int i) throws Exception {
        super.endInput(i);
        if (this.wrappedOperator instanceof BoundedMultiInput) {
            this.setIterationContextRound(Integer.MAX_VALUE);
            ((BoundedMultiInput)this.wrappedOperator).endInput(i);
            this.clearIterationContextRound();
        }
    }
}

