/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.typeinfo;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.iteration.IterationRecord;

public class IterationRecordSerializer<T>
extends TypeSerializer<IterationRecord<T>> {
    private final TypeSerializer<T> innerSerializer;

    public IterationRecordSerializer(TypeSerializer<T> innerSerializer) {
        this.innerSerializer = innerSerializer;
    }

    public TypeSerializer<T> getInnerSerializer() {
        return this.innerSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<IterationRecord<T>> duplicate() {
        return new IterationRecordSerializer<T>(this.innerSerializer.duplicate());
    }

    public IterationRecord<T> createInstance() {
        return null;
    }

    public IterationRecord<T> copy(IterationRecord<T> from) {
        switch (from.getType()) {
            case RECORD: {
                return IterationRecord.newRecord(this.innerSerializer.copy(from.getValue()), from.getEpoch());
            }
            case EPOCH_WATERMARK: {
                return IterationRecord.newEpochWatermark(from.getEpoch(), from.getSender());
            }
            case BARRIER: {
                return IterationRecord.newBarrier(from.getCheckpointId());
            }
        }
        throw new RuntimeException("Unsupported mini-batch record type " + (Object)((Object)from.getType()));
    }

    public IterationRecord<T> copy(IterationRecord<T> from, IterationRecord<T> reuse) {
        from.setType(reuse.getType());
        reuse.setEpoch(from.getEpoch());
        switch (from.getType()) {
            case RECORD: {
                if (reuse.getValue() != null) {
                    this.innerSerializer.copy(from.getValue(), reuse.getValue());
                    break;
                }
                reuse.setValue(this.innerSerializer.copy(from.getValue()));
                break;
            }
            case EPOCH_WATERMARK: {
                reuse.setSender(from.getSender());
                break;
            }
            case BARRIER: {
                reuse.setCheckpointId(from.getCheckpointId());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported mini-batch record type " + (Object)((Object)from.getType()));
            }
        }
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(IterationRecord<T> record, DataOutputView target) throws IOException {
        target.writeByte((int)((byte)record.getType().ordinal()));
        this.serializerNumber(record.getEpoch(), target);
        switch (record.getType()) {
            case RECORD: {
                this.innerSerializer.serialize(record.getValue(), target);
                break;
            }
            case EPOCH_WATERMARK: {
                StringSerializer.INSTANCE.serialize(record.getSender(), target);
                break;
            }
            case BARRIER: {
                LongSerializer.INSTANCE.serialize(Long.valueOf(record.getCheckpointId()), target);
                break;
            }
            default: {
                throw new IOException("Unsupported mini-batch record type " + (Object)((Object)record.getType()));
            }
        }
    }

    public IterationRecord<T> deserialize(DataInputView source) throws IOException {
        byte type = source.readByte();
        int epoch = this.deserializeNumber(source);
        switch (IterationRecord.Type.values()[type]) {
            case RECORD: {
                Object value = this.innerSerializer.deserialize(source);
                return IterationRecord.newRecord(value, epoch);
            }
            case EPOCH_WATERMARK: {
                String sender = StringSerializer.INSTANCE.deserialize(source);
                return IterationRecord.newEpochWatermark(epoch, sender);
            }
            case BARRIER: {
                long checkpointId = LongSerializer.INSTANCE.deserialize(source);
                return IterationRecord.newBarrier(checkpointId);
            }
        }
        throw new IOException("Unsupported mini-batch record type " + type);
    }

    public IterationRecord<T> deserialize(IterationRecord<T> reuse, DataInputView source) throws IOException {
        byte type = source.readByte();
        int epoch = this.deserializeNumber(source);
        reuse.setType(IterationRecord.Type.values()[type]);
        reuse.setEpoch(epoch);
        switch (reuse.getType()) {
            case RECORD: {
                if (reuse.getValue() != null) {
                    this.innerSerializer.deserialize(reuse.getValue(), source);
                } else {
                    reuse.setValue(this.innerSerializer.deserialize(source));
                }
                return reuse;
            }
            case EPOCH_WATERMARK: {
                reuse.setSender(StringSerializer.INSTANCE.deserialize(source));
                return reuse;
            }
            case BARRIER: {
                reuse.setCheckpointId(LongSerializer.INSTANCE.deserialize(source));
                return reuse;
            }
        }
        throw new IOException("Unsupported mini-batch record type " + type);
    }

    public void serializerNumber(int value, DataOutputView target) throws IOException {
        if (value <= 127) {
            target.writeByte((int)((byte)value));
        } else {
            while (value > 127) {
                target.writeByte((int)((byte)(value & 0x7F | 0x80)));
                value >>>= 7;
            }
            target.writeByte((int)((byte)(value & 0x7F)));
        }
    }

    public int deserializeNumber(DataInputView source) throws IOException {
        byte next;
        int offset = 0;
        int value = 0;
        while ((next = source.readByte()) < 0) {
            value = (int)((long)value | (long)(next & 0x7F) << offset);
            offset += 7;
        }
        value = (int)((long)value | (long)next << offset);
        return value;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Object record = this.deserialize(source);
        this.serialize((IterationRecord<T>)record, target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IterationRecordSerializer that = (IterationRecordSerializer)((Object)o);
        return Objects.equals(this.innerSerializer, that.innerSerializer);
    }

    public int hashCode() {
        return this.innerSerializer != null ? this.innerSerializer.hashCode() : 0;
    }

    public TypeSerializerSnapshot<IterationRecord<T>> snapshotConfiguration() {
        return new IterationRecordTypeSerializerSnapshot();
    }

    private static final class IterationRecordTypeSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<IterationRecord<T>, IterationRecordSerializer<T>> {
        private static final int CURRENT_VERSION = 1;

        public IterationRecordTypeSerializerSnapshot() {
            super(IterationRecordSerializer.class);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(IterationRecordSerializer<T> iterationRecordSerializer) {
            return new TypeSerializer[]{iterationRecordSerializer.getInnerSerializer()};
        }

        protected IterationRecordSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] typeSerializers) {
            TypeSerializer<?> elementSerializer = typeSerializers[0];
            return new IterationRecordSerializer(elementSerializer);
        }
    }
}

