/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.bucketizer;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.common.param.HasHandleInvalid;
import org.apache.flink.ml.feature.bucketizer.BucketizerParams;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

public class Bucketizer
implements Transformer<Bucketizer>,
BucketizerParams<Bucketizer> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Bucketizer() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String[] inputCols = this.getInputCols();
        String[] outputCols = this.getOutputCols();
        Double[][] splitsArray = this.getSplitsArray();
        Preconditions.checkArgument((inputCols.length == outputCols.length ? 1 : 0) != 0);
        Preconditions.checkArgument((inputCols.length == splitsArray.length ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        Object[] outputTypes = new TypeInformation[outputCols.length];
        Arrays.fill(outputTypes, BasicTypeInfo.DOUBLE_TYPE_INFO);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])outputTypes), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])this.getOutputCols()));
        int[] inputColumnIndexes = TableUtils.getColumnIndexes(inputs[0].getResolvedSchema(), inputCols);
        SingleOutputStreamOperator result = tEnv.toDataStream(inputs[0]).flatMap((FlatMapFunction)new FindBucketFunction(inputColumnIndexes, splitsArray, this.getHandleInvalid()), (TypeInformation)outputTypeInfo);
        return new Table[]{tEnv.fromDataStream((DataStream)result)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static Bucketizer load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (Bucketizer)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class FindBucketFunction
    implements FlatMapFunction<Row, Row> {
        private final int[] inputCols;
        private final String handleInvalid;
        private final Double[][] splitsArray;

        public FindBucketFunction(int[] inputCols, Double[][] splitsArray, String handleInvalid) {
            this.inputCols = inputCols;
            this.splitsArray = splitsArray;
            this.handleInvalid = handleInvalid;
        }

        public void flatMap(Row value, Collector<Row> out) {
            Row outputRow = new Row(this.inputCols.length);
            block10: for (int i = 0; i < this.inputCols.length; ++i) {
                double feature = ((Number)value.getField(this.inputCols[i])).doubleValue();
                Object[] splits = this.splitsArray[i];
                boolean isInvalid = false;
                if (!Double.isNaN(feature)) {
                    double index = Arrays.binarySearch(splits, (Object)feature);
                    if (index >= 0.0) {
                        if (index == (double)(splits.length - 1)) {
                            index -= 1.0;
                        }
                        outputRow.setField(i, (Object)index);
                    } else if ((index = -index - 1.0) == 0.0 || index == (double)splits.length) {
                        isInvalid = true;
                    } else {
                        outputRow.setField(i, (Object)(index - 1.0));
                    }
                } else {
                    isInvalid = true;
                }
                if (!isInvalid) continue;
                switch (this.handleInvalid) {
                    case "error": {
                        throw new RuntimeException("The input contains invalid value. See " + HasHandleInvalid.HANDLE_INVALID + " parameter for more options.");
                    }
                    case "skip": {
                        return;
                    }
                    case "keep": {
                        outputRow.setField(i, (Object)((double)splits.length - 1.0));
                        continue block10;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported " + HasHandleInvalid.HANDLE_INVALID + " type: " + this.handleInvalid);
                    }
                }
            }
            out.collect((Object)Row.join((Row)value, (Row[])new Row[]{outputRow}));
        }
    }
}

