/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Consumer;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.DelayedMessagesBuffer;
import org.apache.flink.statefun.flink.core.message.Message;

final class FlinkStateDelayedMessagesBuffer
implements DelayedMessagesBuffer {
    static final String BUFFER_STATE_NAME = "delayed-messages-buffer";
    static final String INDEX_STATE_NAME = "delayed-message-index";
    private final InternalListState<String, Long, Message> bufferState;
    private final MapState<String, Long> cancellationTokenToTimestamp;

    @Inject
    FlinkStateDelayedMessagesBuffer(@Label(value="delayed-messages-buffer-state") InternalListState<String, Long, Message> bufferState, @Label(value="delayed-message-index") MapState<String, Long> cancellationTokenToTimestamp) {
        this.bufferState = Objects.requireNonNull(bufferState);
        this.cancellationTokenToTimestamp = Objects.requireNonNull(cancellationTokenToTimestamp);
    }

    @Override
    public void forEachMessageAt(long timestamp, Consumer<Message> fn) {
        try {
            this.forEachMessageThrows(timestamp, fn);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public OptionalLong removeMessageByCancellationToken(String token) {
        try {
            return this.remove(token);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed clearing a message with a cancellation token " + token, e);
        }
    }

    @Override
    public void add(Message message, long untilTimestamp) {
        try {
            this.addThrows(message, untilTimestamp);
        }
        catch (Exception e) {
            throw new RuntimeException("Error adding delayed message to state buffer: " + message, e);
        }
    }

    private void forEachMessageThrows(long timestamp, Consumer<Message> fn) throws Exception {
        this.bufferState.setCurrentNamespace((Object)timestamp);
        for (Message message : (Iterable)this.bufferState.get()) {
            this.removeMessageIdMapping(message);
            fn.accept(message);
        }
        this.bufferState.clear();
    }

    private void addThrows(Message message, long untilTimestamp) throws Exception {
        this.bufferState.setCurrentNamespace((Object)untilTimestamp);
        this.bufferState.add((Object)message);
        Optional<String> maybeToken = message.cancellationToken();
        if (!maybeToken.isPresent()) {
            return;
        }
        String cancellationToken = maybeToken.get();
        Long previousTimestamp = (Long)this.cancellationTokenToTimestamp.get((Object)cancellationToken);
        if (previousTimestamp != null) {
            throw new IllegalStateException("Trying to associate a message with cancellation token " + cancellationToken + " and timestamp " + untilTimestamp + ", but a message with the same cancellation token exists and with a timestamp " + previousTimestamp);
        }
        this.cancellationTokenToTimestamp.put((Object)cancellationToken, (Object)untilTimestamp);
    }

    private OptionalLong remove(String cancellationToken) throws Exception {
        Long untilTimestamp = (Long)this.cancellationTokenToTimestamp.get((Object)cancellationToken);
        if (untilTimestamp == null) {
            return OptionalLong.empty();
        }
        this.cancellationTokenToTimestamp.remove((Object)cancellationToken);
        this.bufferState.setCurrentNamespace((Object)untilTimestamp);
        List<Message> newList = FlinkStateDelayedMessagesBuffer.removeMessageByToken((Iterable)this.bufferState.get(), cancellationToken);
        if (!newList.isEmpty()) {
            this.bufferState.update(newList);
            return OptionalLong.empty();
        }
        this.bufferState.clear();
        return OptionalLong.of(untilTimestamp);
    }

    private void removeMessageIdMapping(Message message) throws Exception {
        Optional<String> maybeToken = message.cancellationToken();
        if (maybeToken.isPresent()) {
            this.cancellationTokenToTimestamp.remove((Object)maybeToken.get());
        }
    }

    private static List<Message> removeMessageByToken(Iterable<Message> messages, String token) {
        ArrayList<Message> newList = new ArrayList<Message>();
        for (Message message : messages) {
            Optional<String> thisMessageId = message.cancellationToken();
            if (thisMessageId.isPresent() && Objects.equals(thisMessageId.get(), token)) continue;
            newList.add(message);
        }
        return newList;
    }
}

