/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.nettyclient;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSetter;

public final class NettyRequestReplySpec {
    public final Duration callTimeout;
    public final Duration connectTimeout;
    public final Duration pooledConnectionTTL;
    public final int connectionPoolMaxSize;
    public final int maxRequestOrResponseSizeInBytes;

    public NettyRequestReplySpec(@JsonProperty(value="call") Duration callTimeout, @JsonProperty(value="connect") Duration connectTimeout, @JsonProperty(value="pool_ttl") Duration pooledConnectionTTL, @JsonProperty(value="pool_size") Integer connectionPoolMaxSize, @JsonProperty(value="payload_max_bytes") Integer maxRequestOrResponseSizeInBytes, @JsonProperty(value="timeouts") Timeouts timeouts) {
        this.callTimeout = NettyRequestReplySpec.firstPresentOrDefault(Optional.ofNullable(timeouts).map(Timeouts::getCallTimeout), Optional.ofNullable(callTimeout), () -> Duration.ofMinutes(2L));
        this.connectTimeout = NettyRequestReplySpec.firstPresentOrDefault(Optional.ofNullable(timeouts).map(Timeouts::getConnectTimeout), Optional.ofNullable(connectTimeout), () -> Duration.ofSeconds(20L));
        this.pooledConnectionTTL = Optional.ofNullable(pooledConnectionTTL).orElseGet(() -> Duration.ofSeconds(15L));
        this.connectionPoolMaxSize = Optional.ofNullable(connectionPoolMaxSize).orElse(1024);
        this.maxRequestOrResponseSizeInBytes = Optional.ofNullable(maxRequestOrResponseSizeInBytes).orElse(0x2000000);
    }

    private static <T> T firstPresentOrDefault(Optional<T> a, Optional<T> b, Supplier<T> orElse) {
        return (T)a.orElseGet(() -> b.orElseGet(orElse));
    }

    public static final class Timeouts {
        private static final Duration DEFAULT_HTTP_TIMEOUT = Duration.ofMinutes(1L);
        private static final Duration DEFAULT_HTTP_CONNECT_TIMEOUT = Duration.ofSeconds(10L);
        private Duration callTimeout = DEFAULT_HTTP_TIMEOUT;
        private Duration connectTimeout = DEFAULT_HTTP_CONNECT_TIMEOUT;

        @JsonSetter(value="call")
        public void setCallTimeout(Duration callTimeout) {
            this.callTimeout = Timeouts.requireNonZeroDuration(callTimeout);
        }

        @JsonSetter(value="connect")
        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = Timeouts.requireNonZeroDuration(connectTimeout);
        }

        public Duration getCallTimeout() {
            return this.callTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        private static Duration requireNonZeroDuration(Duration duration) {
            Objects.requireNonNull(duration);
            if (duration.equals(Duration.ZERO)) {
                throw new IllegalArgumentException("Timeout durations must be larger than 0.");
            }
            return duration;
        }
    }
}

