/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.state;

import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.statefun.sdk.state.Expiration;

final class ExpirationUtil {
    private ExpirationUtil() {
    }

    static void configureStateTtl(StateDescriptor<?, ?> handle, Expiration expiration) {
        if (expiration.mode() == Expiration.Mode.NONE) {
            return;
        }
        StateTtlConfig ttlConfig = ExpirationUtil.from(expiration);
        handle.enableTimeToLive(ttlConfig);
    }

    private static StateTtlConfig from(Expiration expiration) {
        long millis = expiration.duration().toMillis();
        StateTtlConfig.Builder builder = StateTtlConfig.newBuilder((Time)Time.milliseconds((long)millis));
        builder.setTtlTimeCharacteristic(StateTtlConfig.TtlTimeCharacteristic.ProcessingTime);
        builder.setStateVisibility(StateTtlConfig.StateVisibility.NeverReturnExpired);
        switch (expiration.mode()) {
            case AFTER_WRITE: {
                builder.setUpdateType(StateTtlConfig.UpdateType.OnCreateAndWrite);
                break;
            }
            case AFTER_READ_OR_WRITE: {
                builder.setUpdateType(StateTtlConfig.UpdateType.OnReadAndWrite);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown expiration mode " + expiration.mode());
            }
        }
        return builder.build();
    }
}

