/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.state;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.statefun.sdk.state.TableAccessor;

final class FlinkTableAccessor<K, V>
implements TableAccessor<K, V> {
    private final MapState<K, V> handle;

    FlinkTableAccessor(MapState<K, V> handle) {
        this.handle = Objects.requireNonNull(handle);
    }

    public void set(K key, V value) {
        try {
            this.handle.put(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public V get(K key) {
        try {
            return (V)this.handle.get(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(K key) {
        try {
            this.handle.remove(key);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<Map.Entry<K, V>> entries() {
        try {
            return this.handle.entries();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<K> keys() {
        try {
            return this.handle.keys();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Iterable<V> values() {
        try {
            return this.handle.values();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.handle.clear();
    }
}

