/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.tokenizer.Tokenizer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class TokenizerExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{"Test for tokenization."}), Row.of((Object[])new Object[]{"Te,st. punct"})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("input", new String[0]);
        Tokenizer tokenizer = (Tokenizer)((Tokenizer)new Tokenizer().setInputCol("input")).setOutputCol("output");
        Table outputTable = tokenizer.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            String inputValue = (String)row.getField(tokenizer.getInputCol());
            Object[] outputValues = (String[])row.getField(tokenizer.getOutputCol());
            System.out.printf("Input Value: %s \tOutput Values: %s\n", inputValue, Arrays.toString(outputValues));
        }
    }
}

