/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.mergetree.compact;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.mergetree.SortedRun;

public class IntervalPartition {
    private final List<DataFileMeta> files;
    private final Comparator<RowData> keyComparator;

    public IntervalPartition(List<DataFileMeta> inputFiles, Comparator<RowData> keyComparator) {
        this.files = new ArrayList<DataFileMeta>(inputFiles);
        this.files.sort((o1, o2) -> {
            int leftResult = keyComparator.compare((RowData)o1.minKey(), (RowData)o2.minKey());
            return leftResult == 0 ? keyComparator.compare((RowData)o1.maxKey(), (RowData)o2.maxKey()) : leftResult;
        });
        this.keyComparator = keyComparator;
    }

    public List<List<SortedRun>> partition() {
        ArrayList<List<SortedRun>> result = new ArrayList<List<SortedRun>>();
        ArrayList<DataFileMeta> section = new ArrayList<DataFileMeta>();
        BinaryRowData bound = null;
        for (DataFileMeta meta : this.files) {
            if (!section.isEmpty() && this.keyComparator.compare((RowData)meta.minKey(), (RowData)bound) > 0) {
                result.add(this.partition(section));
                section.clear();
                bound = null;
            }
            section.add(meta);
            if (bound != null && this.keyComparator.compare((RowData)meta.maxKey(), (RowData)bound) <= 0) continue;
            bound = meta.maxKey();
        }
        if (!section.isEmpty()) {
            result.add(this.partition(section));
        }
        return result;
    }

    private List<SortedRun> partition(List<DataFileMeta> metas) {
        PriorityQueue<List> queue = new PriorityQueue<List>((o1, o2) -> this.keyComparator.compare((RowData)((DataFileMeta)o1.get(o1.size() - 1)).maxKey(), (RowData)((DataFileMeta)o2.get(o2.size() - 1)).maxKey()));
        ArrayList<DataFileMeta> firstRun = new ArrayList<DataFileMeta>();
        firstRun.add(metas.get(0));
        queue.add(firstRun);
        for (int i = 1; i < metas.size(); ++i) {
            DataFileMeta meta = metas.get(i);
            List top = (List)queue.poll();
            if (this.keyComparator.compare((RowData)meta.minKey(), (RowData)((DataFileMeta)top.get(top.size() - 1)).maxKey()) > 0) {
                top.add(meta);
            } else {
                ArrayList<DataFileMeta> newRun = new ArrayList<DataFileMeta>();
                newRun.add(meta);
                queue.add(newRun);
            }
            queue.add(top);
        }
        return queue.stream().map(SortedRun::fromSorted).collect(Collectors.toList());
    }
}

