/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;

public class SerializedJobExecutionResult
implements Serializable {
    private static final long serialVersionUID = -6301865617099921789L;
    private final JobID jobId;
    private final Map<String, SerializedValue<OptionalFailure<Object>>> accumulatorResults;
    private final long netRuntime;

    public SerializedJobExecutionResult(JobID jobID, long netRuntime, Map<String, SerializedValue<OptionalFailure<Object>>> accumulators) {
        this.jobId = jobID;
        this.netRuntime = netRuntime;
        this.accumulatorResults = accumulators;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public long getNetRuntime() {
        return this.netRuntime;
    }

    public long getNetRuntime(TimeUnit desiredUnit) {
        return desiredUnit.convert(this.getNetRuntime(), TimeUnit.MILLISECONDS);
    }

    public Map<String, SerializedValue<OptionalFailure<Object>>> getSerializedAccumulatorResults() {
        return this.accumulatorResults;
    }

    public JobExecutionResult toJobExecutionResult(ClassLoader loader) throws IOException, ClassNotFoundException {
        Map<String, OptionalFailure<Object>> accumulators = AccumulatorHelper.deserializeAccumulators(this.accumulatorResults, loader);
        return new JobExecutionResult(this.jobId, this.netRuntime, accumulators);
    }
}

