/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.store.file.catalog.CatalogLock;

public interface Lock
extends AutoCloseable {
    public <T> T runWithLock(Callable<T> var1) throws Exception;

    @Nullable
    public static Lock fromCatalog(CatalogLock.Factory lockFactory, ObjectPath tablePath) {
        if (lockFactory == null) {
            return null;
        }
        return Lock.fromCatalog(lockFactory.create(), tablePath);
    }

    @Nullable
    public static Lock fromCatalog(CatalogLock lock, ObjectPath tablePath) {
        if (lock == null) {
            return null;
        }
        return new CatalogLockImpl(lock, tablePath);
    }

    public static class CatalogLockImpl
    implements Lock {
        private final CatalogLock catalogLock;
        private final ObjectPath tablePath;

        private CatalogLockImpl(CatalogLock catalogLock, ObjectPath tablePath) {
            this.catalogLock = catalogLock;
            this.tablePath = tablePath;
        }

        @Override
        public <T> T runWithLock(Callable<T> callable) throws Exception {
            return this.catalogLock.runWithLock(this.tablePath.getDatabaseName(), this.tablePath.getObjectName(), callable);
        }

        @Override
        public void close() throws Exception {
            this.catalogLock.close();
        }
    }
}

