/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

public class IterableUtils {
    public static <E> Stream<E> toStream(Iterable<E> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? ((Collection)iterable).stream() : StreamSupport.stream(iterable.spliterator(), false);
    }

    @Internal
    public static <K, V, G extends Iterable<K>> Iterable<V> flatMap(final Iterable<G> itemGroups, final Function<K, V> mapper) {
        return () -> new Iterator<V>(){
            private final Iterator groupIterator;
            private Iterator itemIterator;
            {
                this.groupIterator = itemGroups.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.itemIterator == null || !this.itemIterator.hasNext()) {
                    if (!this.groupIterator.hasNext()) {
                        return false;
                    }
                    this.itemIterator = ((Iterable)this.groupIterator.next()).iterator();
                }
                return true;
            }

            @Override
            public V next() {
                if (this.hasNext()) {
                    return mapper.apply(this.itemIterator.next());
                }
                throw new NoSuchElementException();
            }
        };
    }

    private IterableUtils() {
    }
}

