/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.FileCompactStrategy;
import org.apache.flink.connector.file.sink.compactor.FileCompactor;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorOperator;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.util.function.SerializableSupplierWithException;

@Internal
public class CompactorOperatorFactory
extends AbstractStreamOperatorFactory<CommittableMessage<FileSinkCommittable>>
implements OneInputStreamOperatorFactory<CompactorRequest, CommittableMessage<FileSinkCommittable>> {
    private final FileCompactStrategy strategy;
    private final FileCompactor fileCompactor;
    private final SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier;
    private final SerializableSupplierWithException<BucketWriter<?, String>, IOException> bucketWriterProvider;

    public CompactorOperatorFactory(FileCompactStrategy strategy, FileCompactor fileCompactor, SerializableSupplierWithException<SimpleVersionedSerializer<FileSinkCommittable>, IOException> committableSerializerSupplier, SerializableSupplierWithException<BucketWriter<?, String>, IOException> bucketWriterProvider) {
        this.strategy = strategy;
        this.fileCompactor = fileCompactor;
        this.committableSerializerSupplier = committableSerializerSupplier;
        this.bucketWriterProvider = bucketWriterProvider;
    }

    @Override
    public <T extends StreamOperator<CommittableMessage<FileSinkCommittable>>> T createStreamOperator(StreamOperatorParameters<CommittableMessage<FileSinkCommittable>> parameters) {
        try {
            CompactorOperator compactOperator = new CompactorOperator(this.strategy, (SimpleVersionedSerializer)this.committableSerializerSupplier.get(), this.fileCompactor, (BucketWriter)this.bucketWriterProvider.get());
            compactOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)compactOperator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator for " + parameters.getStreamConfig().getOperatorName(), e);
        }
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CompactorOperator.class;
    }
}

