/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.OptionalInt;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.util.Preconditions;

public final class DataSetMetaInfo {
    private static final int UNKNOWN = -1;
    private final int numRegisteredPartitions;
    private final int numTotalPartitions;

    private DataSetMetaInfo(int numRegisteredPartitions, int numTotalPartitions) {
        this.numRegisteredPartitions = numRegisteredPartitions;
        this.numTotalPartitions = numTotalPartitions;
    }

    public OptionalInt getNumRegisteredPartitions() {
        return this.numRegisteredPartitions == -1 ? OptionalInt.empty() : OptionalInt.of(this.numRegisteredPartitions);
    }

    public int getNumTotalPartitions() {
        return this.numTotalPartitions;
    }

    static DataSetMetaInfo withoutNumRegisteredPartitions(int numTotalPartitions) {
        return new DataSetMetaInfo(-1, numTotalPartitions);
    }

    @VisibleForTesting
    public static DataSetMetaInfo withNumRegisteredPartitions(int numRegisteredPartitions, int numTotalPartitions) {
        Preconditions.checkArgument(numRegisteredPartitions > 0);
        return new DataSetMetaInfo(numRegisteredPartitions, numTotalPartitions);
    }
}

