/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.operators.coordination.EventSender;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.concurrent.FutureUtils;

final class OperatorEventValve
implements EventSender {
    private static final long NO_CHECKPOINT = Long.MIN_VALUE;
    private final List<BlockedEvent> blockedEvents = new ArrayList<BlockedEvent>();
    private long currentCheckpointId = Long.MIN_VALUE;
    private long lastCheckpointId = Long.MIN_VALUE;
    private boolean shut;
    @Nullable
    private ComponentMainThreadExecutor mainThreadExecutor;

    OperatorEventValve() {
    }

    public void setMainThreadExecutorForValidation(ComponentMainThreadExecutor mainThreadExecutor) {
        this.mainThreadExecutor = mainThreadExecutor;
    }

    public boolean isShut() {
        this.checkRunsInMainThread();
        return this.shut;
    }

    @Override
    public void sendEvent(Callable<CompletableFuture<Acknowledge>> sendAction, CompletableFuture<Acknowledge> result) {
        this.checkRunsInMainThread();
        if (this.shut) {
            this.blockedEvents.add(new BlockedEvent(sendAction, result));
        } else {
            this.callSendAction(sendAction, result);
        }
    }

    public void markForCheckpoint(long checkpointId) {
        this.checkRunsInMainThread();
        if (this.currentCheckpointId != Long.MIN_VALUE && this.currentCheckpointId != checkpointId) {
            throw new IllegalStateException(String.format("Cannot mark for checkpoint %d, already marked for checkpoint %d", checkpointId, this.currentCheckpointId));
        }
        if (checkpointId <= this.lastCheckpointId) {
            throw new IllegalStateException(String.format("Regressing checkpoint IDs. Previous checkpointId = %d, new checkpointId = %d", this.lastCheckpointId, checkpointId));
        }
        this.currentCheckpointId = checkpointId;
        this.lastCheckpointId = checkpointId;
    }

    public boolean tryShutValve(long checkpointId) {
        this.checkRunsInMainThread();
        if (checkpointId == this.currentCheckpointId) {
            this.shut = true;
            return true;
        }
        return false;
    }

    public void openValveAndUnmarkCheckpoint(long expectedCheckpointId) {
        this.checkRunsInMainThread();
        if (expectedCheckpointId != this.currentCheckpointId) {
            throw new IllegalStateException(String.format("Valve closed for different checkpoint: closed for = %d, expected = %d", this.currentCheckpointId, expectedCheckpointId));
        }
        this.openValveAndUnmarkCheckpoint();
    }

    public void openValveAndUnmarkCheckpoint() {
        this.checkRunsInMainThread();
        this.currentCheckpointId = Long.MIN_VALUE;
        if (!this.shut) {
            return;
        }
        for (BlockedEvent blockedEvent : this.blockedEvents) {
            this.callSendAction(blockedEvent.sendAction, blockedEvent.future);
        }
        this.blockedEvents.clear();
        this.shut = false;
    }

    private void checkRunsInMainThread() {
        if (this.mainThreadExecutor != null) {
            this.mainThreadExecutor.assertRunningInMainThread();
        }
    }

    private void callSendAction(Callable<CompletableFuture<Acknowledge>> sendAction, CompletableFuture<Acknowledge> result) {
        try {
            CompletableFuture<Acknowledge> sendResult = sendAction.call();
            FutureUtils.forward(sendResult, result);
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError(t);
            result.completeExceptionally(t);
        }
    }

    private static final class BlockedEvent {
        final Callable<CompletableFuture<Acknowledge>> sendAction;
        final CompletableFuture<Acknowledge> future;

        BlockedEvent(Callable<CompletableFuture<Acknowledge>> sendAction, CompletableFuture<Acknowledge> future) {
            this.sendAction = sendAction;
            this.future = future;
        }
    }
}

