/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.RegisteredBroadcastStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredOperatorStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;

public abstract class RegisteredStateMetaInfoBase {
    @Nonnull
    protected final String name;

    public RegisteredStateMetaInfoBase(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public abstract StateMetaInfoSnapshot snapshot();

    public static RegisteredStateMetaInfoBase fromMetaInfoSnapshot(@Nonnull StateMetaInfoSnapshot snapshot) {
        StateMetaInfoSnapshot.BackendStateType backendStateType = snapshot.getBackendStateType();
        switch (backendStateType) {
            case KEY_VALUE: {
                return new RegisteredKeyValueStateBackendMetaInfo(snapshot);
            }
            case OPERATOR: {
                return new RegisteredOperatorStateBackendMetaInfo(snapshot);
            }
            case BROADCAST: {
                return new RegisteredBroadcastStateBackendMetaInfo(snapshot);
            }
            case PRIORITY_QUEUE: {
                return new RegisteredPriorityQueueStateBackendMetaInfo(snapshot);
            }
        }
        throw new IllegalArgumentException("Unknown backend state type: " + (Object)((Object)backendStateType));
    }
}

