/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.mergetree.Increment;

public class ManifestCommittable {
    private final String identifier;
    private final Map<Integer, Long> logOffsets;
    private final Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> newFiles;
    private final Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactBefore;
    private final Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactAfter;

    public ManifestCommittable(String identifier) {
        this.identifier = identifier;
        this.logOffsets = new HashMap<Integer, Long>();
        this.newFiles = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
        this.compactBefore = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
        this.compactAfter = new HashMap<BinaryRowData, Map<Integer, List<DataFileMeta>>>();
    }

    public ManifestCommittable(String identifier, Map<Integer, Long> logOffsets, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> newFiles, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactBefore, Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactAfter) {
        this.identifier = identifier;
        this.logOffsets = logOffsets;
        this.newFiles = newFiles;
        this.compactBefore = compactBefore;
        this.compactAfter = compactAfter;
    }

    public void addFileCommittable(BinaryRowData partition, int bucket, Increment increment) {
        ManifestCommittable.addFiles(this.newFiles, partition, bucket, increment.newFiles());
        ManifestCommittable.addFiles(this.compactBefore, partition, bucket, increment.compactBefore());
        ManifestCommittable.addFiles(this.compactAfter, partition, bucket, increment.compactAfter());
    }

    public void addLogOffset(int bucket, long offset) {
        if (this.logOffsets.containsKey(bucket)) {
            throw new RuntimeException(String.format("bucket-%d appears multiple times, which is not possible.", bucket));
        }
        this.logOffsets.put(bucket, offset);
    }

    private static void addFiles(Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> map, BinaryRowData partition, int bucket, List<DataFileMeta> files) {
        map.computeIfAbsent(partition, k -> new HashMap()).computeIfAbsent(bucket, k -> new ArrayList()).addAll(files);
    }

    public String identifier() {
        return this.identifier;
    }

    public Map<Integer, Long> logOffsets() {
        return this.logOffsets;
    }

    public Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> newFiles() {
        return this.newFiles;
    }

    public Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactBefore() {
        return this.compactBefore;
    }

    public Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> compactAfter() {
        return this.compactAfter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ManifestCommittable that = (ManifestCommittable)o;
        return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.logOffsets, that.logOffsets) && Objects.equals(this.newFiles, that.newFiles) && Objects.equals(this.compactBefore, that.compactBefore) && Objects.equals(this.compactAfter, that.compactAfter);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.logOffsets, this.newFiles, this.compactBefore, this.compactAfter);
    }

    public String toString() {
        return "ManifestCommittable { identifier = " + this.identifier + ", logOffsets = " + this.logOffsets + ", newFiles =\n" + ManifestCommittable.filesToString(this.newFiles) + ", compactBefore =\n" + ManifestCommittable.filesToString(this.compactBefore) + ", compactAfter =\n" + ManifestCommittable.filesToString(this.compactAfter) + '}';
    }

    private static String filesToString(Map<BinaryRowData, Map<Integer, List<DataFileMeta>>> files) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<BinaryRowData, Map<Integer, List<DataFileMeta>>> entryWithPartition : files.entrySet()) {
            for (Map.Entry<Integer, List<DataFileMeta>> entryWithBucket : entryWithPartition.getValue().entrySet()) {
                for (DataFileMeta dataFile : entryWithBucket.getValue()) {
                    builder.append("  * partition: ").append(entryWithPartition.getKey()).append(", bucket: ").append(entryWithBucket.getKey()).append(", file: ").append(dataFile.fileName()).append("\n");
                }
            }
        }
        return builder.toString();
    }
}

