/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.data.DataFileMeta;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.operation.FileStoreScan;
import org.apache.flink.table.store.file.operation.FileStoreWrite;
import org.apache.flink.table.store.file.utils.SnapshotManager;

public abstract class AbstractFileStoreWrite<T>
implements FileStoreWrite<T> {
    private final SnapshotManager snapshotManager;
    private final FileStoreScan scan;

    protected AbstractFileStoreWrite(SnapshotManager snapshotManager, FileStoreScan scan) {
        this.snapshotManager = snapshotManager;
        this.scan = scan;
    }

    protected List<DataFileMeta> scanExistingFileMetas(BinaryRowData partition, int bucket) {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        ArrayList<DataFileMeta> existingFileMetas = Lists.newArrayList();
        if (latestSnapshotId != null) {
            this.scan.withSnapshot(latestSnapshotId).withPartitionFilter(Collections.singletonList(partition)).withBucket(bucket).plan().files().stream().map(ManifestEntry::file).forEach(existingFileMetas::add);
        }
        return existingFileMetas;
    }

    protected long getMaxSequenceNumber(List<DataFileMeta> fileMetas) {
        return fileMetas.stream().map(DataFileMeta::maxSequenceNumber).max(Long::compare).orElse(-1L);
    }
}

