/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Public;

@Public
public enum FlinkVersion {
    v1_3("1.3"),
    v1_4("1.4"),
    v1_5("1.5"),
    v1_6("1.6"),
    v1_7("1.7"),
    v1_8("1.8"),
    v1_9("1.9"),
    v1_10("1.10"),
    v1_11("1.11"),
    v1_12("1.12"),
    v1_13("1.13"),
    v1_14("1.14"),
    v1_15("1.15");

    private final String versionStr;
    private static final Map<String, FlinkVersion> CODE_MAP;

    private FlinkVersion(String versionStr) {
        this.versionStr = versionStr;
    }

    public String toString() {
        return this.versionStr;
    }

    public boolean isNewerVersionThan(FlinkVersion otherVersion) {
        return this.ordinal() > otherVersion.ordinal();
    }

    public static Set<FlinkVersion> rangeOf(FlinkVersion start, FlinkVersion end) {
        return Stream.of(FlinkVersion.values()).filter(v -> v.ordinal() >= start.ordinal() && v.ordinal() <= end.ordinal()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Optional<FlinkVersion> byCode(String code) {
        return Optional.ofNullable(CODE_MAP.get(code));
    }

    public static FlinkVersion current() {
        return FlinkVersion.values()[FlinkVersion.values().length - 1];
    }

    static {
        CODE_MAP = Arrays.stream(FlinkVersion.values()).collect(Collectors.toMap(v -> v.versionStr, Function.identity()));
    }
}

