/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import javax.annotation.Nullable;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class ByteBufUtils {
    @Nullable
    public static ByteBuf accumulate(ByteBuf target, ByteBuf source, int targetAccumulationSize, int accumulatedSize) {
        if (accumulatedSize == 0 && source.readableBytes() >= targetAccumulationSize) {
            return source;
        }
        int copyLength = Math.min(source.readableBytes(), targetAccumulationSize - accumulatedSize);
        if (copyLength > 0) {
            target.writeBytes(source, copyLength);
        }
        if (accumulatedSize + copyLength == targetAccumulationSize) {
            return target;
        }
        return null;
    }
}

