/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler;

import java.io.File;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.WebOptions;
import org.apache.flink.util.Preconditions;

public class RestHandlerConfiguration {
    private final long refreshInterval;
    private final int maxCheckpointStatisticCacheEntries;
    private final Time timeout;
    private final File webUiDir;
    private final boolean webSubmitEnabled;
    private final boolean webCancelEnabled;

    public RestHandlerConfiguration(long refreshInterval, int maxCheckpointStatisticCacheEntries, Time timeout, File webUiDir, boolean webSubmitEnabled, boolean webCancelEnabled) {
        Preconditions.checkArgument(refreshInterval > 0L, "The refresh interval (ms) should be larger than 0.");
        this.refreshInterval = refreshInterval;
        this.maxCheckpointStatisticCacheEntries = maxCheckpointStatisticCacheEntries;
        this.timeout = Preconditions.checkNotNull(timeout);
        this.webUiDir = Preconditions.checkNotNull(webUiDir);
        this.webSubmitEnabled = webSubmitEnabled;
        this.webCancelEnabled = webCancelEnabled;
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    public int getMaxCheckpointStatisticCacheEntries() {
        return this.maxCheckpointStatisticCacheEntries;
    }

    public Time getTimeout() {
        return this.timeout;
    }

    public File getWebUiDir() {
        return this.webUiDir;
    }

    public boolean isWebSubmitEnabled() {
        return this.webSubmitEnabled;
    }

    public boolean isWebCancelEnabled() {
        return this.webCancelEnabled;
    }

    public static RestHandlerConfiguration fromConfiguration(Configuration configuration) {
        long refreshInterval = configuration.getLong(WebOptions.REFRESH_INTERVAL);
        int maxCheckpointStatisticCacheEntries = configuration.getInteger(WebOptions.CHECKPOINTS_HISTORY_SIZE);
        Time timeout = Time.milliseconds(configuration.getLong(WebOptions.TIMEOUT));
        String rootDir = "flink-web-ui";
        File webUiDir = new File(configuration.getString(WebOptions.TMP_DIR), "flink-web-ui");
        boolean webSubmitEnabled = configuration.getBoolean(WebOptions.SUBMIT_ENABLE);
        boolean webCancelEnabled = configuration.getBoolean(WebOptions.CANCEL_ENABLE);
        return new RestHandlerConfiguration(refreshInterval, maxCheckpointStatisticCacheEntries, timeout, webUiDir, webSubmitEnabled, webCancelEnabled);
    }
}

