/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.utils;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.utils.ProjectedRowData;

public class ProjectKeyRecordReader
implements RecordReader<KeyValue> {
    private final RecordReader<KeyValue> reader;
    private final ProjectedRowData projectedRow;

    public ProjectKeyRecordReader(RecordReader<KeyValue> reader, int[][] keyProjectedFields) {
        this.reader = reader;
        this.projectedRow = ProjectedRowData.from(keyProjectedFields);
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
        RecordReader.RecordIterator<KeyValue> batch = this.reader.readBatch();
        if (batch == null) {
            return null;
        }
        return new ProjectedIterator(batch, this.projectedRow);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static class ProjectedIterator
    implements RecordReader.RecordIterator<KeyValue> {
        private final RecordReader.RecordIterator<KeyValue> iterator;
        private final ProjectedRowData projectedRow;

        public ProjectedIterator(RecordReader.RecordIterator<KeyValue> iterator, ProjectedRowData projectedRow) {
            this.iterator = iterator;
            this.projectedRow = projectedRow;
        }

        @Override
        public KeyValue next() throws IOException {
            KeyValue kv = this.iterator.next();
            if (kv == null) {
                return null;
            }
            return kv.replaceKey(this.projectedRow.replaceRow(kv.key()));
        }

        @Override
        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

