/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;

public class SparkTypeUtils {
    private SparkTypeUtils() {
    }

    public static StructType fromFlinkRowType(RowType type) {
        return (StructType)SparkTypeUtils.fromFlinkType(type);
    }

    public static DataType fromFlinkType(LogicalType type) {
        return type.accept(FlinkToSparkTypeVisitor.INSTANCE);
    }

    public static LogicalType toFlinkType(DataType dataType) {
        return SparkToFlinkTypeVisitor.visit(dataType);
    }

    private static class SparkToFlinkTypeVisitor {
        private SparkToFlinkTypeVisitor() {
        }

        static LogicalType visit(DataType type) {
            return SparkToFlinkTypeVisitor.visit(type, new SparkToFlinkTypeVisitor());
        }

        static LogicalType visit(DataType type, SparkToFlinkTypeVisitor visitor) {
            if (type instanceof StructType) {
                StructField[] fields = ((StructType)type).fields();
                ArrayList<LogicalType> fieldResults = new ArrayList<LogicalType>(fields.length);
                for (StructField field : fields) {
                    fieldResults.add(SparkToFlinkTypeVisitor.visit(field.dataType(), visitor));
                }
                return visitor.struct((StructType)type, fieldResults);
            }
            if (type instanceof MapType) {
                return visitor.map((MapType)type, SparkToFlinkTypeVisitor.visit(((MapType)type).keyType(), visitor), SparkToFlinkTypeVisitor.visit(((MapType)type).valueType(), visitor));
            }
            if (type instanceof org.apache.spark.sql.types.ArrayType) {
                return visitor.array((org.apache.spark.sql.types.ArrayType)type, SparkToFlinkTypeVisitor.visit(((org.apache.spark.sql.types.ArrayType)type).elementType(), visitor));
            }
            if (type instanceof UserDefinedType) {
                throw new UnsupportedOperationException("User-defined types are not supported");
            }
            return visitor.atomic(type);
        }

        public LogicalType struct(StructType struct, List<LogicalType> fieldResults) {
            StructField[] fields = struct.fields();
            ArrayList<RowType.RowField> newFields = new ArrayList<RowType.RowField>(fields.length);
            for (int i = 0; i < fields.length; ++i) {
                StructField field = fields[i];
                LogicalType fieldType = fieldResults.get(i).copy(field.nullable());
                String comment = (String)field.getComment().getOrElse(() -> null);
                newFields.add(new RowType.RowField(field.name(), fieldType, comment));
            }
            return new RowType(newFields);
        }

        public LogicalType array(org.apache.spark.sql.types.ArrayType array, LogicalType elementResult) {
            return new ArrayType(elementResult.copy(array.containsNull()));
        }

        public LogicalType map(MapType map, LogicalType keyResult, LogicalType valueResult) {
            return new org.apache.flink.table.types.logical.MapType(keyResult.copy(false), valueResult.copy(map.valueContainsNull()));
        }

        public LogicalType atomic(DataType atomic) {
            if (atomic instanceof org.apache.spark.sql.types.BooleanType) {
                return new BooleanType();
            }
            if (atomic instanceof ByteType) {
                return new TinyIntType();
            }
            if (atomic instanceof ShortType) {
                return new SmallIntType();
            }
            if (atomic instanceof IntegerType) {
                return new IntType();
            }
            if (atomic instanceof LongType) {
                return new BigIntType();
            }
            if (atomic instanceof org.apache.spark.sql.types.FloatType) {
                return new FloatType();
            }
            if (atomic instanceof org.apache.spark.sql.types.DoubleType) {
                return new DoubleType();
            }
            if (atomic instanceof StringType) {
                return new VarCharType(Integer.MAX_VALUE);
            }
            if (atomic instanceof DateType) {
                return new org.apache.flink.table.types.logical.DateType();
            }
            if (atomic instanceof TimestampType) {
                return new org.apache.flink.table.types.logical.TimestampType();
            }
            if (atomic instanceof DecimalType) {
                return new org.apache.flink.table.types.logical.DecimalType(((DecimalType)atomic).precision(), ((DecimalType)atomic).scale());
            }
            if (atomic instanceof org.apache.spark.sql.types.BinaryType) {
                return new VarBinaryType(Integer.MAX_VALUE);
            }
            throw new UnsupportedOperationException("Not a supported type: " + atomic.catalogString());
        }
    }

    private static class FlinkToSparkTypeVisitor
    extends LogicalTypeDefaultVisitor<DataType> {
        private static final FlinkToSparkTypeVisitor INSTANCE = new FlinkToSparkTypeVisitor();

        private FlinkToSparkTypeVisitor() {
        }

        @Override
        public DataType visit(CharType charType) {
            return DataTypes.StringType;
        }

        @Override
        public DataType visit(VarCharType varCharType) {
            return DataTypes.StringType;
        }

        @Override
        public DataType visit(BooleanType booleanType) {
            return DataTypes.BooleanType;
        }

        @Override
        public DataType visit(BinaryType binaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public DataType visit(VarBinaryType varBinaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public DataType visit(org.apache.flink.table.types.logical.DecimalType decimalType) {
            return DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        @Override
        public DataType visit(TinyIntType tinyIntType) {
            return DataTypes.ByteType;
        }

        @Override
        public DataType visit(SmallIntType smallIntType) {
            return DataTypes.ShortType;
        }

        @Override
        public DataType visit(IntType intType) {
            return DataTypes.IntegerType;
        }

        @Override
        public DataType visit(BigIntType bigIntType) {
            return DataTypes.LongType;
        }

        @Override
        public DataType visit(FloatType floatType) {
            return DataTypes.FloatType;
        }

        @Override
        public DataType visit(DoubleType doubleType) {
            return DataTypes.DoubleType;
        }

        @Override
        public DataType visit(org.apache.flink.table.types.logical.DateType dateType) {
            return DataTypes.DateType;
        }

        @Override
        public DataType visit(org.apache.flink.table.types.logical.TimestampType timestampType) {
            return DataTypes.TimestampType;
        }

        @Override
        public DataType visit(LocalZonedTimestampType localZonedTimestampType) {
            return DataTypes.TimestampType;
        }

        @Override
        public DataType visit(ArrayType arrayType) {
            LogicalType elementType = arrayType.getElementType();
            return DataTypes.createArrayType((DataType)elementType.accept(this), (boolean)elementType.isNullable());
        }

        @Override
        public DataType visit(MultisetType multisetType) {
            return DataTypes.createMapType((DataType)multisetType.getElementType().accept(this), (DataType)DataTypes.IntegerType, (boolean)false);
        }

        @Override
        public DataType visit(org.apache.flink.table.types.logical.MapType mapType) {
            return DataTypes.createMapType((DataType)mapType.getKeyType().accept(this), (DataType)mapType.getValueType().accept(this), (boolean)mapType.getValueType().isNullable());
        }

        @Override
        public DataType visit(RowType rowType) {
            ArrayList<StructField> fields = new ArrayList<StructField>(rowType.getFieldCount());
            for (RowType.RowField field : rowType.getFields()) {
                StructField structField = DataTypes.createStructField((String)field.getName(), (DataType)field.getType().accept(this), (boolean)field.getType().isNullable());
                structField = field.getDescription().map(arg_0 -> ((StructField)structField).withComment(arg_0)).orElse(structField);
                fields.add(structField);
            }
            return DataTypes.createStructType(fields);
        }

        @Override
        protected DataType defaultMethod(LogicalType logicalType) {
            throw new UnsupportedOperationException("Unsupported type: " + logicalType);
        }
    }
}

