/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.manifest;

import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.io.DataFileMetaSerializer;
import org.apache.flink.table.store.file.manifest.FileKind;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.file.utils.VersionedObjectSerializer;

public class ManifestEntrySerializer
extends VersionedObjectSerializer<ManifestEntry> {
    private static final long serialVersionUID = 1L;
    private final DataFileMetaSerializer dataFileMetaSerializer = new DataFileMetaSerializer();

    public ManifestEntrySerializer() {
        super(ManifestEntry.schema());
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public RowData convertTo(ManifestEntry entry) {
        GenericRowData row = new GenericRowData(5);
        row.setField(0, (Object)entry.kind().toByteValue());
        row.setField(1, (Object)SerializationUtils.serializeBinaryRow(entry.partition()));
        row.setField(2, (Object)entry.bucket());
        row.setField(3, (Object)entry.totalBuckets());
        row.setField(4, (Object)this.dataFileMetaSerializer.toRow(entry.file()));
        return row;
    }

    @Override
    public ManifestEntry convertFrom(int version, RowData row) {
        if (version != 2) {
            if (version == 1) {
                throw new IllegalArgumentException(String.format("The current version %s is not compatible with the version %s, please recreate the table.", this.getVersion(), version));
            }
            throw new IllegalArgumentException("Unsupported version: " + version);
        }
        return new ManifestEntry(FileKind.fromByteValue(row.getByte(0)), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), row.getInt(2), row.getInt(3), this.dataFileMetaSerializer.fromRow(row.getRow(4, this.dataFileMetaSerializer.numFields())));
    }
}

