/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.connector;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.connector.AbstractTableStoreFactory;
import org.apache.flink.table.store.connector.sink.TableStoreSink;
import org.apache.flink.table.store.file.catalog.CatalogLock;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.UpdateSchema;

public class TableStoreConnectorFactory
extends AbstractTableStoreFactory {
    @Nullable
    private final CatalogLock.Factory lockFactory;

    public TableStoreConnectorFactory() {
        this(null);
    }

    public TableStoreConnectorFactory(@Nullable CatalogLock.Factory lockFactory) {
        this.lockFactory = lockFactory;
    }

    public String factoryIdentifier() {
        return "table-store";
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        if (this.isFlinkTable(context)) {
            return FactoryUtil.createTableSource(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        this.createTableIfNeeded(context);
        return super.createDynamicTableSource(context);
    }

    @Override
    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        if (this.isFlinkTable(context)) {
            return FactoryUtil.createTableSink(null, (ObjectIdentifier)context.getObjectIdentifier(), (ResolvedCatalogTable)context.getCatalogTable(), (ReadableConfig)context.getConfiguration(), (ClassLoader)context.getClassLoader(), (boolean)context.isTemporary());
        }
        this.createTableIfNeeded(context);
        TableStoreSink sink = (TableStoreSink)super.createDynamicTableSink(context);
        sink.setLockFactory(this.lockFactory);
        return sink;
    }

    private void createTableIfNeeded(DynamicTableFactory.Context context) {
        Path tablePath;
        SchemaManager schemaManager;
        ResolvedCatalogTable table = context.getCatalogTable();
        Configuration options = Configuration.fromMap((Map)table.getOptions());
        if (((Boolean)options.get(CoreOptions.AUTO_CREATE)).booleanValue() && !(schemaManager = new SchemaManager(tablePath = CoreOptions.path(table.getOptions()))).latest().isPresent()) {
            try {
                schemaManager.commitNewVersion(UpdateSchema.fromCatalogTable((CatalogTable)table));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isFlinkTable(DynamicTableFactory.Context context) {
        String identifier = (String)context.getCatalogTable().getOptions().get(FactoryUtil.CONNECTOR.key());
        return identifier != null && !"table-store".equals(identifier);
    }
}

