/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.system;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.io.DataFileMetaSerializer;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.utils.IteratorRecordReader;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.store.table.DataTable;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.Table;
import org.apache.flink.table.store.table.source.DataSplit;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarBinaryType;

public class BucketsTable
implements DataTable {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable wrapped;
    private final boolean isContinuous;

    public BucketsTable(FileStoreTable wrapped, boolean isContinuous) {
        this.wrapped = wrapped;
        this.isContinuous = isContinuous;
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public String name() {
        return "__internal_buckets_" + this.wrapped.location().getName();
    }

    @Override
    public RowType rowType() {
        RowType partitionType = this.wrapped.schema().logicalPartitionType();
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        fields.add(new RowType.RowField("_SNAPSHOT_ID", (LogicalType)new BigIntType()));
        fields.addAll(partitionType.getFields());
        fields.add(new RowType.RowField("_BUCKET", (LogicalType)new IntType()));
        fields.add(new RowType.RowField("_FILES", (LogicalType)new VarBinaryType()));
        return new RowType(fields);
    }

    public static RowType partitionWithBucketRowType(RowType partitionType) {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>(partitionType.getFields());
        fields.add(new RowType.RowField("_BUCKET", (LogicalType)new IntType()));
        return new RowType(fields);
    }

    @Override
    public DataTableScan newScan() {
        return this.wrapped.newScan();
    }

    @Override
    public CoreOptions options() {
        return this.wrapped.options();
    }

    @Override
    public TableRead newRead() {
        return new BucketsRead();
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BucketsTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.isContinuous);
    }

    private class BucketsRead
    implements TableRead {
        private final DataFileMetaSerializer dataFileMetaSerializer = new DataFileMetaSerializer();

        private BucketsRead() {
        }

        @Override
        public TableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableRead withProjection(int[][] projection) {
            throw new UnsupportedOperationException("BucketsRead does not support projection");
        }

        @Override
        public RecordReader<RowData> createReader(Split split) throws IOException {
            if (!(split instanceof DataSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            DataSplit dataSplit = (DataSplit)split;
            JoinedRowData row = new JoinedRowData((RowData)GenericRowData.of((Object[])new Object[]{dataSplit.snapshotId()}), (RowData)dataSplit.partition());
            row = new JoinedRowData((RowData)row, (RowData)GenericRowData.of((Object[])new Object[]{dataSplit.bucket()}));
            List<Object> files = Collections.emptyList();
            if (BucketsTable.this.isContinuous) {
                files = dataSplit.files();
            }
            row = new JoinedRowData((RowData)row, (RowData)GenericRowData.of((Object[])new Object[]{this.dataFileMetaSerializer.serializeList(files)}));
            return new IteratorRecordReader<JoinedRowData>(Collections.singletonList(row).iterator());
        }
    }
}

