/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.distributions;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.distributions.RangeBoundaries;
import org.apache.flink.api.common.typeutils.TypeComparator;

@Internal
public class CommonRangeBoundaries<T>
implements RangeBoundaries<T> {
    private final TypeComparator<T> typeComparator;
    private final Object[][] boundaries;
    private final TypeComparator[] flatComparators;
    private final Object[] keys;

    public CommonRangeBoundaries(TypeComparator<T> typeComparators, Object[][] boundaries) {
        this.typeComparator = typeComparators;
        this.flatComparators = typeComparators.getFlatComparators();
        this.keys = new Object[this.flatComparators.length];
        this.boundaries = boundaries;
    }

    @Override
    public int getRangeIndex(T record) {
        return this.binarySearch(record);
    }

    private int binarySearch(T record) {
        int low = 0;
        int high = this.boundaries.length - 1;
        this.typeComparator.extractKeys(record, this.keys, 0);
        while (low <= high) {
            int mid = low + high >>> 1;
            int result = this.compareKeys(this.flatComparators, this.keys, this.boundaries[mid]);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    private int compareKeys(TypeComparator[] flatComparators, Object[] keys, Object[] boundary) {
        if (flatComparators.length != keys.length || flatComparators.length != boundary.length) {
            throw new RuntimeException("Can not compare keys with boundary due to mismatched length.");
        }
        for (int i = 0; i < flatComparators.length; ++i) {
            int result = flatComparators[i].compare(keys[i], boundary[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

