/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.jobmaster.ServiceConnectionManager;

public class AbstractServiceConnectionManager<S>
implements ServiceConnectionManager<S> {
    protected final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    protected S service;
    @GuardedBy(value="lock")
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connect(S service) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.service = service;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.service = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.service = null;
        }
    }

    protected final void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("This connection manager has already been closed.");
        }
    }

    protected final boolean isConnected() {
        return this.service != null;
    }
}

