/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

@Internal
public final class ChangelogStateHandleStreamImpl
implements ChangelogStateHandle {
    private static final long serialVersionUID = -8070326169926626355L;
    private final KeyGroupRange keyGroupRange;
    private final List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets;
    private final long size;
    private final long incrementalSize;
    private final StateHandleID stateHandleID;
    private final String storageIdentifier;

    public ChangelogStateHandleStreamImpl(List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets, KeyGroupRange keyGroupRange, long size, long incrementalSize, String storageIdentifier) {
        this(handlesAndOffsets, keyGroupRange, size, incrementalSize, storageIdentifier, new StateHandleID(UUID.randomUUID().toString()));
    }

    private ChangelogStateHandleStreamImpl(List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets, KeyGroupRange keyGroupRange, long size, long incrementalSize, String storageIdentifier, StateHandleID stateHandleId) {
        this.handlesAndOffsets = handlesAndOffsets;
        this.keyGroupRange = keyGroupRange;
        this.size = size;
        this.incrementalSize = incrementalSize;
        this.storageIdentifier = storageIdentifier;
        this.stateHandleID = stateHandleId;
    }

    public static ChangelogStateHandleStreamImpl restore(List<Tuple2<StreamStateHandle, Long>> handlesAndOffsets, KeyGroupRange keyGroupRange, long size, long incrementalSize, String storageIdentifier, StateHandleID stateHandleID) {
        return new ChangelogStateHandleStreamImpl(handlesAndOffsets, keyGroupRange, size, incrementalSize, storageIdentifier, stateHandleID);
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry, long checkpointID) {
        this.handlesAndOffsets.forEach(handleAndOffset -> stateRegistry.registerReference(ChangelogStateHandleStreamImpl.getKey((StreamStateHandle)handleAndOffset.f0), (StreamStateHandle)handleAndOffset.f0, checkpointID));
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        return this.keyGroupRange;
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        KeyGroupRange offsets = this.keyGroupRange.getIntersection(keyGroupRange);
        if (offsets.getNumberOfKeyGroups() == 0) {
            return null;
        }
        return new ChangelogStateHandleStreamImpl(this.handlesAndOffsets, offsets, 0L, 0L, this.storageIdentifier);
    }

    @Override
    public StateHandleID getStateHandleId() {
        return this.stateHandleID;
    }

    @Override
    public void discardState() throws Exception {
    }

    @Override
    public long getStateSize() {
        return this.size;
    }

    @Override
    public long getCheckpointedSize() {
        return this.incrementalSize;
    }

    @Override
    public String getStorageIdentifier() {
        return this.storageIdentifier;
    }

    private static SharedStateRegistryKey getKey(StreamStateHandle stateHandle) {
        if (stateHandle instanceof FileStateHandle) {
            return new SharedStateRegistryKey(((FileStateHandle)stateHandle).getFilePath().toString());
        }
        if (stateHandle instanceof ByteStreamStateHandle) {
            return new SharedStateRegistryKey(((ByteStreamStateHandle)stateHandle).getHandleName());
        }
        return new SharedStateRegistryKey(Integer.toString(System.identityHashCode(stateHandle)));
    }

    public List<Tuple2<StreamStateHandle, Long>> getHandlesAndOffsets() {
        return Collections.unmodifiableList(this.handlesAndOffsets);
    }
}

