/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.graph.SimpleTransformationTranslator;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class AbstractTwoInputTransformationTranslator<IN1, IN2, OUT, OP extends Transformation<OUT>>
extends SimpleTransformationTranslator<OUT, OP> {
    protected Collection<Integer> translateInternal(Transformation<OUT> transformation, Transformation<IN1> firstInputTransformation, Transformation<IN2> secondInputTransformation, StreamOperatorFactory<OUT> operatorFactory, @Nullable TypeInformation<?> keyTypeInfo, @Nullable KeySelector<IN1, ?> firstKeySelector, @Nullable KeySelector<IN2, ?> secondKeySelector, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull(firstInputTransformation);
        Preconditions.checkNotNull(secondInputTransformation);
        Preconditions.checkNotNull(operatorFactory);
        Preconditions.checkNotNull(context);
        StreamGraph streamGraph = context.getStreamGraph();
        String slotSharingGroup = context.getSlotSharingGroup();
        int transformationId = transformation.getId();
        ExecutionConfig executionConfig = streamGraph.getExecutionConfig();
        streamGraph.addCoOperator(transformationId, slotSharingGroup, transformation.getCoLocationGroupKey(), operatorFactory, firstInputTransformation.getOutputType(), secondInputTransformation.getOutputType(), transformation.getOutputType(), transformation.getName());
        if (firstKeySelector != null || secondKeySelector != null) {
            Preconditions.checkState(keyTypeInfo != null, "Keyed Transformation without provided key type information.");
            TypeSerializer<?> keySerializer = keyTypeInfo.createSerializer(executionConfig);
            streamGraph.setTwoInputStateKey(transformationId, firstKeySelector, secondKeySelector, keySerializer);
        }
        int parallelism = transformation.getParallelism() != -1 ? transformation.getParallelism() : executionConfig.getParallelism();
        streamGraph.setParallelism(transformationId, parallelism);
        streamGraph.setMaxParallelism(transformationId, transformation.getMaxParallelism());
        for (Integer inputId : context.getStreamNodeIds(firstInputTransformation)) {
            streamGraph.addEdge(inputId, transformationId, 1);
        }
        for (Integer inputId : context.getStreamNodeIds(secondInputTransformation)) {
            streamGraph.addEdge(inputId, transformationId, 2);
        }
        return Collections.singleton(transformationId);
    }
}

