/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.vault.ksm.conf;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.keepersecurity.secretsManager.core.KeyValueStorage;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.properties.BooleanGuacamoleProperty;
import org.apache.guacamole.properties.GuacamoleProperty;
import org.apache.guacamole.vault.conf.VaultConfigurationService;
import org.apache.guacamole.vault.ksm.conf.KsmConfigProperty;

@Singleton
public class KsmConfigurationService
extends VaultConfigurationService {
    @Inject
    private Environment environment;
    private static final String TOKEN_MAPPING_FILENAME = "ksm-token-mapping.yml";
    private static final String PROPERTIES_FILENAME = "guacamole.properties.ksm";
    private static final KsmConfigProperty KSM_CONFIG = new KsmConfigProperty(){

        public String getName() {
            return "ksm-config";
        }
    };
    private static final BooleanGuacamoleProperty ALLOW_UNVERIFIED_CERT = new BooleanGuacamoleProperty(){

        public String getName() {
            return "ksm-allow-unverified-cert";
        }
    };

    public KsmConfigurationService() {
        super(TOKEN_MAPPING_FILENAME, PROPERTIES_FILENAME);
    }

    public boolean getAllowUnverifiedCertificate() throws GuacamoleException {
        return (Boolean)this.environment.getProperty((GuacamoleProperty)ALLOW_UNVERIFIED_CERT, (Object)false);
    }

    public SecretsManagerOptions getSecretsManagerOptions() throws GuacamoleException {
        return new SecretsManagerOptions((KeyValueStorage)this.environment.getRequiredProperty((GuacamoleProperty)KSM_CONFIG), null, this.getAllowUnverifiedCertificate());
    }
}

