/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ssl;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleResourceNotFoundException;
import org.apache.guacamole.auth.ssl.SSLAuthenticationSessionManager;
import org.apache.guacamole.auth.ssl.conf.ConfigurationService;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

@Singleton
public class AuthenticationProviderService
implements SSOAuthenticationProviderService {
    @Inject
    private ConfigurationService confService;
    @Inject
    private SSLAuthenticationSessionManager sessionManager;
    @Inject
    private Provider<SSOAuthenticatedUser> authenticatedUserProvider;
    private static final String AUTH_SESSION_PARAMETER_NAME = "state";

    public static String getSessionIdentifier(Credentials credentials) {
        return credentials != null ? credentials.getParameter(AUTH_SESSION_PARAMETER_NAME) : null;
    }

    private SSOAuthenticatedUser processIdentity(Credentials credentials) {
        String state = AuthenticationProviderService.getSessionIdentifier(credentials);
        String username = this.sessionManager.getIdentity(state);
        if (username == null) {
            return null;
        }
        SSOAuthenticatedUser authenticatedUser = (SSOAuthenticatedUser)this.authenticatedUserProvider.get();
        authenticatedUser.init(username, credentials, Collections.emptySet(), Collections.emptyMap());
        return authenticatedUser;
    }

    public SSOAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        String host = credentials.getHeader("Host");
        if (host == null) {
            return null;
        }
        if (this.confService.isPrimaryHostname(host)) {
            return this.processIdentity(credentials);
        }
        throw new GuacamoleInvalidCredentialsException("Authentication is only allowed against the primary URL of this Guacamole instance.", new CredentialsInfo(Arrays.asList(new RedirectField("primaryURI", this.confService.getPrimaryURI(), new TranslatableMessage("LOGIN.INFO_REDIRECT_PENDING")))));
    }

    public URI getLoginURI() throws GuacamoleException {
        throw new GuacamoleResourceNotFoundException("No such resource.");
    }

    public void shutdown() {
        this.sessionManager.shutdown();
    }
}

