/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.cas;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.Arrays;
import javax.ws.rs.core.UriBuilder;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.cas.conf.ConfigurationService;
import org.apache.guacamole.auth.cas.ticket.TicketValidationService;
import org.apache.guacamole.auth.sso.SSOAuthenticationProviderService;
import org.apache.guacamole.auth.sso.user.SSOAuthenticatedUser;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

@Singleton
public class AuthenticationProviderService
implements SSOAuthenticationProviderService {
    public static final String TICKET_PARAMETER_NAME = "ticket";
    private static final String CAS_LOGIN_URI = "login";
    @Inject
    private ConfigurationService confService;
    @Inject
    private TicketValidationService ticketService;

    public SSOAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        String ticket = credentials.getParameter(TICKET_PARAMETER_NAME);
        if (ticket != null) {
            return this.ticketService.validateTicket(ticket, credentials);
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", new CredentialsInfo(Arrays.asList(new RedirectField(TICKET_PARAMETER_NAME, this.getLoginURI(), new TranslatableMessage("LOGIN.INFO_IDP_REDIRECT_PENDING")))));
    }

    public URI getLoginURI() throws GuacamoleException {
        return UriBuilder.fromUri((URI)this.confService.getAuthorizationEndpoint()).path(CAS_LOGIN_URI).queryParam("service", new Object[]{this.confService.getRedirectURI()}).build(new Object[0]);
    }

    public void shutdown() {
    }
}

