/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.cli.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.cli.CLITestHelper;

public abstract class CommandExecutor {
    protected String[] getCommandAsArgs(String cmd, String masterKey, String master) {
        String regex = "'([^']*)'|\"([^\"]*)\"|(\\S+)";
        Matcher matcher = Pattern.compile(regex).matcher(cmd);
        ArrayList<String> args = new ArrayList<String>();
        String arg = null;
        while (matcher.find()) {
            arg = matcher.group(1) != null ? matcher.group(1) : (matcher.group(2) != null ? matcher.group(2) : matcher.group(3));
            arg = arg.replaceAll(masterKey, master);
            arg = arg.replaceAll("CLITEST_DATA", new File(CLITestHelper.TEST_CACHE_DATA_DIR).toURI().toString().replace(' ', '+'));
            arg = arg.replaceAll("USERNAME", System.getProperty("user.name"));
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result executeCommand(String cmd) throws Exception {
        int exitCode = 0;
        Exception lastException = null;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        System.setOut(new PrintStream(bao));
        System.setErr(new PrintStream(bao));
        try {
            exitCode = this.execute(cmd);
        }
        catch (Exception e) {
            e.printStackTrace();
            lastException = e;
            exitCode = -1;
        }
        finally {
            System.setOut(origOut);
            System.setErr(origErr);
        }
        return new Result(bao.toString(), exitCode, lastException, cmd);
    }

    protected abstract int execute(String var1) throws Exception;

    public static class Result {
        final String commandOutput;
        final int exitCode;
        final Exception exception;
        final String cmdExecuted;

        public Result(String commandOutput, int exitCode, Exception exception, String cmdExecuted) {
            this.commandOutput = commandOutput;
            this.exitCode = exitCode;
            this.exception = exception;
            this.cmdExecuted = cmdExecuted;
        }

        public String getCommandOutput() {
            return this.commandOutput;
        }

        public int getExitCode() {
            return this.exitCode;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getCommand() {
            return this.cmdExecuted;
        }
    }
}

